/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core;

import com.arangodb.shaded.vertx.codegen.annotations.Fluent;
import com.arangodb.shaded.vertx.codegen.annotations.GenIgnore;
import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Context;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.Promise;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import com.arangodb.shaded.vertx.core.impl.future.FailedFuture;
import com.arangodb.shaded.vertx.core.impl.future.PromiseInternal;
import com.arangodb.shaded.vertx.core.impl.future.SucceededFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public interface Future<T>
extends AsyncResult<T> {
    public static <T> Future<T> future(Handler<Promise<T>> handler) {
        Promise promise = Promise.promise();
        try {
            handler.handle(promise);
        }
        catch (Throwable e) {
            promise.tryFail(e);
        }
        return promise.future();
    }

    public static <T> Future<T> succeededFuture() {
        return SucceededFuture.EMPTY;
    }

    public static <T> Future<T> succeededFuture(T result) {
        if (result == null) {
            return Future.succeededFuture();
        }
        return new SucceededFuture<T>(result);
    }

    public static <T> Future<T> failedFuture(Throwable t) {
        return new FailedFuture(t);
    }

    public static <T> Future<T> failedFuture(String failureMessage) {
        return new FailedFuture(failureMessage);
    }

    public boolean isComplete();

    @Fluent
    public Future<T> onComplete(Handler<AsyncResult<T>> var1);

    @Fluent
    default public Future<T> onSuccess(Handler<T> handler) {
        return this.onComplete(ar -> {
            if (ar.succeeded()) {
                handler.handle(ar.result());
            }
        });
    }

    @Fluent
    default public Future<T> onFailure(Handler<Throwable> handler) {
        return this.onComplete(ar -> {
            if (ar.failed()) {
                handler.handle(ar.cause());
            }
        });
    }

    @Override
    public T result();

    @Override
    public Throwable cause();

    @Override
    public boolean succeeded();

    @Override
    public boolean failed();

    default public <U> Future<U> flatMap(Function<T, Future<U>> mapper) {
        return this.compose(mapper);
    }

    default public <U> Future<U> compose(Function<T, Future<U>> mapper) {
        return this.compose(mapper, Future::failedFuture);
    }

    default public Future<T> recover(Function<Throwable, Future<T>> mapper) {
        return this.compose(Future::succeededFuture, mapper);
    }

    public <U> Future<U> compose(Function<T, Future<U>> var1, Function<Throwable, Future<U>> var2);

    public <U> Future<U> transform(Function<AsyncResult<T>, Future<U>> var1);

    public <U> Future<T> eventually(Function<Void, Future<U>> var1);

    @Override
    public <U> Future<U> map(Function<T, U> var1);

    @Override
    public <V> Future<V> map(V var1);

    @Override
    default public <V> Future<V> mapEmpty() {
        return (Future)AsyncResult.super.mapEmpty();
    }

    @Override
    public Future<T> otherwise(Function<Throwable, T> var1);

    @Override
    public Future<T> otherwise(T var1);

    @Override
    default public Future<T> otherwiseEmpty() {
        return (Future)AsyncResult.super.otherwiseEmpty();
    }

    default public Future<T> andThen(Handler<AsyncResult<T>> handler) {
        return this.transform(ar -> {
            handler.handle((AsyncResult)ar);
            return (Future)ar;
        });
    }

    @GenIgnore
    default public CompletionStage<T> toCompletionStage() {
        CompletableFuture completableFuture = new CompletableFuture();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                completableFuture.complete(ar.result());
            } else {
                completableFuture.completeExceptionally(ar.cause());
            }
        });
        return completableFuture;
    }

    @GenIgnore
    public static <T> Future<T> fromCompletionStage(CompletionStage<T> completionStage) {
        Promise promise = Promise.promise();
        completionStage.whenComplete((value, err) -> {
            if (err != null) {
                promise.fail((Throwable)err);
            } else {
                promise.complete(value);
            }
        });
        return promise.future();
    }

    @GenIgnore
    public static <T> Future<T> fromCompletionStage(CompletionStage<T> completionStage, Context context) {
        PromiseInternal promise = ((ContextInternal)context).promise();
        completionStage.whenComplete((value, err) -> {
            if (err != null) {
                promise.fail((Throwable)err);
            } else {
                promise.complete(value);
            }
        });
        return promise.future();
    }
}

