/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core;

import com.arangodb.shaded.netty.channel.EventLoopGroup;
import com.arangodb.shaded.vertx.codegen.annotations.CacheReturn;
import com.arangodb.shaded.vertx.codegen.annotations.Fluent;
import com.arangodb.shaded.vertx.codegen.annotations.GenIgnore;
import com.arangodb.shaded.vertx.codegen.annotations.Nullable;
import com.arangodb.shaded.vertx.codegen.annotations.VertxGen;
import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Context;
import com.arangodb.shaded.vertx.core.DeploymentOptions;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.Promise;
import com.arangodb.shaded.vertx.core.TimeoutStream;
import com.arangodb.shaded.vertx.core.Verticle;
import com.arangodb.shaded.vertx.core.VertxOptions;
import com.arangodb.shaded.vertx.core.WorkerExecutor;
import com.arangodb.shaded.vertx.core.datagram.DatagramSocket;
import com.arangodb.shaded.vertx.core.datagram.DatagramSocketOptions;
import com.arangodb.shaded.vertx.core.dns.DnsClient;
import com.arangodb.shaded.vertx.core.dns.DnsClientOptions;
import com.arangodb.shaded.vertx.core.eventbus.EventBus;
import com.arangodb.shaded.vertx.core.file.FileSystem;
import com.arangodb.shaded.vertx.core.http.HttpClient;
import com.arangodb.shaded.vertx.core.http.HttpClientOptions;
import com.arangodb.shaded.vertx.core.http.HttpServer;
import com.arangodb.shaded.vertx.core.http.HttpServerOptions;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import com.arangodb.shaded.vertx.core.impl.VertxBuilder;
import com.arangodb.shaded.vertx.core.metrics.Measured;
import com.arangodb.shaded.vertx.core.net.NetClient;
import com.arangodb.shaded.vertx.core.net.NetClientOptions;
import com.arangodb.shaded.vertx.core.net.NetServer;
import com.arangodb.shaded.vertx.core.net.NetServerOptions;
import com.arangodb.shaded.vertx.core.shareddata.SharedData;
import com.arangodb.shaded.vertx.core.spi.VerticleFactory;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

@VertxGen
public interface Vertx
extends Measured {
    public static Vertx vertx() {
        return Vertx.vertx(new VertxOptions());
    }

    public static Vertx vertx(VertxOptions options) {
        return new VertxBuilder(options).init().vertx();
    }

    public static void clusteredVertx(VertxOptions options, Handler<AsyncResult<Vertx>> resultHandler) {
        new VertxBuilder(options).init().clusteredVertx(resultHandler);
    }

    public static Future<Vertx> clusteredVertx(VertxOptions options) {
        Promise<Vertx> promise = Promise.promise();
        Vertx.clusteredVertx(options, promise);
        return promise.future();
    }

    public static @Nullable Context currentContext() {
        return ContextInternal.current();
    }

    public Context getOrCreateContext();

    public NetServer createNetServer(NetServerOptions var1);

    default public NetServer createNetServer() {
        return this.createNetServer(new NetServerOptions());
    }

    public NetClient createNetClient(NetClientOptions var1);

    default public NetClient createNetClient() {
        return this.createNetClient(new NetClientOptions());
    }

    public HttpServer createHttpServer(HttpServerOptions var1);

    default public HttpServer createHttpServer() {
        return this.createHttpServer(new HttpServerOptions());
    }

    public HttpClient createHttpClient(HttpClientOptions var1);

    default public HttpClient createHttpClient() {
        return this.createHttpClient(new HttpClientOptions());
    }

    public DatagramSocket createDatagramSocket(DatagramSocketOptions var1);

    default public DatagramSocket createDatagramSocket() {
        return this.createDatagramSocket(new DatagramSocketOptions());
    }

    @CacheReturn
    public FileSystem fileSystem();

    @CacheReturn
    public EventBus eventBus();

    public DnsClient createDnsClient(int var1, String var2);

    public DnsClient createDnsClient();

    public DnsClient createDnsClient(DnsClientOptions var1);

    @CacheReturn
    public SharedData sharedData();

    public long setTimer(long var1, Handler<Long> var3);

    @Deprecated
    public TimeoutStream timerStream(long var1);

    default public long setPeriodic(long delay, Handler<Long> handler) {
        return this.setPeriodic(delay, delay, handler);
    }

    public long setPeriodic(long var1, long var3, Handler<Long> var5);

    @Deprecated
    default public TimeoutStream periodicStream(long delay) {
        return this.periodicStream(0L, delay);
    }

    @Deprecated
    public TimeoutStream periodicStream(long var1, long var3);

    public boolean cancelTimer(long var1);

    public void runOnContext(Handler<Void> var1);

    public Future<Void> close();

    public void close(Handler<AsyncResult<Void>> var1);

    @GenIgnore(value={"permitted-type"})
    default public Future<String> deployVerticle(Verticle verticle) {
        return this.deployVerticle(verticle, new DeploymentOptions());
    }

    @GenIgnore(value={"permitted-type"})
    public void deployVerticle(Verticle var1, Handler<AsyncResult<String>> var2);

    @GenIgnore(value={"permitted-type"})
    public Future<String> deployVerticle(Verticle var1, DeploymentOptions var2);

    @GenIgnore
    public Future<String> deployVerticle(Class<? extends Verticle> var1, DeploymentOptions var2);

    @GenIgnore(value={"permitted-type"})
    public Future<String> deployVerticle(Supplier<Verticle> var1, DeploymentOptions var2);

    @GenIgnore(value={"permitted-type"})
    public void deployVerticle(Verticle var1, DeploymentOptions var2, Handler<AsyncResult<String>> var3);

    @GenIgnore
    public void deployVerticle(Class<? extends Verticle> var1, DeploymentOptions var2, Handler<AsyncResult<String>> var3);

    @GenIgnore(value={"permitted-type"})
    public void deployVerticle(Supplier<Verticle> var1, DeploymentOptions var2, Handler<AsyncResult<String>> var3);

    default public Future<String> deployVerticle(String name) {
        return this.deployVerticle(name, new DeploymentOptions());
    }

    default public void deployVerticle(String name, Handler<AsyncResult<String>> completionHandler) {
        this.deployVerticle(name, new DeploymentOptions(), completionHandler);
    }

    public Future<String> deployVerticle(String var1, DeploymentOptions var2);

    public void deployVerticle(String var1, DeploymentOptions var2, Handler<AsyncResult<String>> var3);

    public Future<Void> undeploy(String var1);

    public void undeploy(String var1, Handler<AsyncResult<Void>> var2);

    public Set<String> deploymentIDs();

    @GenIgnore(value={"permitted-type"})
    public void registerVerticleFactory(VerticleFactory var1);

    @GenIgnore(value={"permitted-type"})
    public void unregisterVerticleFactory(VerticleFactory var1);

    @GenIgnore(value={"permitted-type"})
    public Set<VerticleFactory> verticleFactories();

    public boolean isClustered();

    default public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<@Nullable T>> resultHandler) {
        Context context = this.getOrCreateContext();
        context.executeBlocking(blockingCodeHandler, ordered, resultHandler);
    }

    default public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<@Nullable T>> resultHandler) {
        this.executeBlocking(blockingCodeHandler, true, resultHandler);
    }

    default public <T> Future<@Nullable T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered) {
        Context context = this.getOrCreateContext();
        return context.executeBlocking(blockingCodeHandler, ordered);
    }

    default public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler) {
        return this.executeBlocking(blockingCodeHandler, true);
    }

    @GenIgnore(value={"permitted-type"})
    public EventLoopGroup nettyEventLoopGroup();

    public WorkerExecutor createSharedWorkerExecutor(String var1);

    public WorkerExecutor createSharedWorkerExecutor(String var1, int var2);

    public WorkerExecutor createSharedWorkerExecutor(String var1, int var2, long var3);

    public WorkerExecutor createSharedWorkerExecutor(String var1, int var2, long var3, TimeUnit var5);

    @CacheReturn
    public boolean isNativeTransportEnabled();

    @CacheReturn
    public Throwable unavailableNativeTransportCause();

    @Fluent
    public Vertx exceptionHandler(@Nullable Handler<Throwable> var1);

    @GenIgnore
    public @Nullable Handler<Throwable> exceptionHandler();
}

