/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.eventbus;

import com.arangodb.shaded.vertx.codegen.annotations.CacheReturn;
import com.arangodb.shaded.vertx.codegen.annotations.Nullable;
import com.arangodb.shaded.vertx.codegen.annotations.VertxGen;
import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.MultiMap;
import com.arangodb.shaded.vertx.core.eventbus.DeliveryOptions;
import com.arangodb.shaded.vertx.core.eventbus.ReplyException;
import com.arangodb.shaded.vertx.core.eventbus.ReplyFailure;

@VertxGen
public interface Message<T> {
    public String address();

    public MultiMap headers();

    @CacheReturn
    public T body();

    public @Nullable String replyAddress();

    public boolean isSend();

    default public void reply(@Nullable Object message) {
        this.reply(message, new DeliveryOptions());
    }

    public void reply(@Nullable Object var1, DeliveryOptions var2);

    default public <R> void replyAndRequest(@Nullable Object message, Handler<AsyncResult<Message<R>>> replyHandler) {
        this.replyAndRequest(message, new DeliveryOptions(), replyHandler);
    }

    default public <R> Future<Message<R>> replyAndRequest(@Nullable Object message) {
        return this.replyAndRequest(message, new DeliveryOptions());
    }

    default public <R> void replyAndRequest(@Nullable Object message, DeliveryOptions options, Handler<AsyncResult<Message<R>>> replyHandler) {
        this.replyAndRequest(message, options).onComplete(replyHandler);
    }

    public <R> Future<Message<R>> replyAndRequest(@Nullable Object var1, DeliveryOptions var2);

    default public void fail(int failureCode, String message) {
        this.reply(new ReplyException(ReplyFailure.RECIPIENT_FAILURE, failureCode, message));
    }
}

