/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.http.impl;

import com.arangodb.shaded.netty.buffer.Unpooled;
import com.arangodb.shaded.netty.channel.ChannelHandlerContext;
import com.arangodb.shaded.netty.channel.ChannelPipeline;
import com.arangodb.shaded.netty.channel.ChannelPromise;
import com.arangodb.shaded.netty.channel.EventLoop;
import com.arangodb.shaded.netty.handler.codec.DecoderResult;
import com.arangodb.shaded.netty.handler.codec.http.DefaultFullHttpResponse;
import com.arangodb.shaded.netty.handler.codec.http.DefaultHttpContent;
import com.arangodb.shaded.netty.handler.codec.http.DefaultHttpRequest;
import com.arangodb.shaded.netty.handler.codec.http.EmptyHttpHeaders;
import com.arangodb.shaded.netty.handler.codec.http.FullHttpRequest;
import com.arangodb.shaded.netty.handler.codec.http.HttpContent;
import com.arangodb.shaded.netty.handler.codec.http.HttpHeaderNames;
import com.arangodb.shaded.netty.handler.codec.http.HttpObject;
import com.arangodb.shaded.netty.handler.codec.http.HttpResponseStatus;
import com.arangodb.shaded.netty.handler.codec.http.HttpVersion;
import com.arangodb.shaded.netty.handler.codec.http.LastHttpContent;
import com.arangodb.shaded.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import com.arangodb.shaded.netty.handler.codec.http.websocketx.WebSocketFrame;
import com.arangodb.shaded.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import com.arangodb.shaded.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import com.arangodb.shaded.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import com.arangodb.shaded.netty.handler.codec.http.websocketx.WebSocketVersion;
import com.arangodb.shaded.netty.util.ReferenceCountUtil;
import com.arangodb.shaded.netty.util.concurrent.GenericFutureListener;
import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.Promise;
import com.arangodb.shaded.vertx.core.Vertx;
import com.arangodb.shaded.vertx.core.buffer.Buffer;
import com.arangodb.shaded.vertx.core.http.HttpHeaders;
import com.arangodb.shaded.vertx.core.http.HttpMethod;
import com.arangodb.shaded.vertx.core.http.HttpServerOptions;
import com.arangodb.shaded.vertx.core.http.HttpServerRequest;
import com.arangodb.shaded.vertx.core.http.ServerWebSocket;
import com.arangodb.shaded.vertx.core.http.impl.Http1xConnectionBase;
import com.arangodb.shaded.vertx.core.http.impl.Http1xServerRequest;
import com.arangodb.shaded.vertx.core.http.impl.HttpChunkContentCompressor;
import com.arangodb.shaded.vertx.core.http.impl.HttpServerConnection;
import com.arangodb.shaded.vertx.core.http.impl.HttpUtils;
import com.arangodb.shaded.vertx.core.http.impl.ServerWebSocketImpl;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import com.arangodb.shaded.vertx.core.impl.future.PromiseInternal;
import com.arangodb.shaded.vertx.core.impl.logging.Logger;
import com.arangodb.shaded.vertx.core.impl.logging.LoggerFactory;
import com.arangodb.shaded.vertx.core.net.NetSocket;
import com.arangodb.shaded.vertx.core.net.impl.NetSocketImpl;
import com.arangodb.shaded.vertx.core.net.impl.SslChannelProvider;
import com.arangodb.shaded.vertx.core.net.impl.VertxHandler;
import com.arangodb.shaded.vertx.core.spi.metrics.HttpServerMetrics;
import com.arangodb.shaded.vertx.core.spi.metrics.Metrics;
import com.arangodb.shaded.vertx.core.spi.tracing.VertxTracer;
import com.arangodb.shaded.vertx.core.tracing.TracingPolicy;
import java.util.function.Supplier;

public class Http1xServerConnection
extends Http1xConnectionBase<ServerWebSocketImpl>
implements HttpServerConnection {
    private static final Logger log = LoggerFactory.getLogger(Http1xServerConnection.class);
    private final String serverOrigin;
    private final Supplier<ContextInternal> streamContextSupplier;
    private final SslChannelProvider sslChannelProvider;
    private final TracingPolicy tracingPolicy;
    private boolean requestFailed;
    private Http1xServerRequest requestInProgress;
    private Http1xServerRequest responseInProgress;
    private boolean channelPaused;
    private boolean writable;
    private Handler<HttpServerRequest> requestHandler;
    private Handler<HttpServerRequest> invalidRequestHandler;
    final HttpServerMetrics metrics;
    final boolean handle100ContinueAutomatically;
    final HttpServerOptions options;

    public Http1xServerConnection(Supplier<ContextInternal> streamContextSupplier, SslChannelProvider sslChannelProvider, HttpServerOptions options, ChannelHandlerContext chctx, ContextInternal context, String serverOrigin, HttpServerMetrics metrics) {
        super(context, chctx);
        this.serverOrigin = serverOrigin;
        this.streamContextSupplier = streamContextSupplier;
        this.options = options;
        this.sslChannelProvider = sslChannelProvider;
        this.metrics = metrics;
        this.handle100ContinueAutomatically = options.isHandle100ContinueAutomatically();
        this.tracingPolicy = options.getTracingPolicy();
        this.writable = true;
    }

    TracingPolicy tracingPolicy() {
        return this.tracingPolicy;
    }

    @Override
    public HttpServerConnection handler(Handler<HttpServerRequest> handler) {
        this.requestHandler = handler;
        return this;
    }

    @Override
    public HttpServerConnection invalidRequestHandler(Handler<HttpServerRequest> handler) {
        this.invalidRequestHandler = handler;
        return this;
    }

    @Override
    public HttpServerMetrics metrics() {
        return this.metrics;
    }

    @Override
    public void handleMessage(Object msg) {
        assert (msg != null);
        if (msg == LastHttpContent.EMPTY_LAST_CONTENT) {
            this.onEnd();
        } else if (msg instanceof DefaultHttpRequest) {
            Http1xServerRequest req;
            DefaultHttpRequest request = (DefaultHttpRequest)msg;
            ContextInternal requestCtx = this.streamContextSupplier.get();
            this.requestInProgress = req = new Http1xServerRequest(this, request, requestCtx);
            if (this.responseInProgress != null) {
                this.enqueueRequest(req);
                return;
            }
            this.responseInProgress = this.requestInProgress;
            req.handleBegin(this.writable);
            Handler<HttpServerRequest> handler = request.decoderResult().isSuccess() ? this.requestHandler : this.invalidRequestHandler;
            req.context.emit(req, handler);
        } else {
            this.handleOther(msg);
        }
    }

    private void enqueueRequest(Http1xServerRequest req) {
        this.responseInProgress.enqueue(req);
        req.pause();
    }

    private void handleOther(Object msg) {
        if (msg instanceof DefaultHttpContent || msg instanceof HttpContent) {
            this.onContent(msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWsFrame((WebSocketFrame)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onContent(Object msg) {
        Http1xServerRequest request;
        HttpContent content = (HttpContent)msg;
        if (!content.decoderResult().isSuccess()) {
            this.handleError(content);
            return;
        }
        Buffer buffer = Buffer.buffer(VertxHandler.safeBuffer(content.content()));
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            request = this.requestInProgress;
        }
        request.context.execute(buffer, request::handleContent);
        if (content instanceof LastHttpContent) {
            this.onEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEnd() {
        Http1xServerRequest request;
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            request = this.requestInProgress;
            this.requestInProgress = null;
        }
        request.context.execute(request, Http1xServerRequest::handleEnd);
    }

    void responseComplete() {
        EventLoop eventLoop = this.context.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            if (Metrics.METRICS_ENABLED) {
                this.reportResponseComplete();
            }
            Http1xServerRequest request = this.responseInProgress;
            this.responseInProgress = null;
            DecoderResult result = request.decoderResult();
            if (result.isSuccess()) {
                Http1xServerRequest next = request.next();
                if (next != null) {
                    this.handleNext(next);
                }
            } else {
                ChannelPromise channelFuture = this.channelFuture();
                this.writeToChannel((Object)Unpooled.EMPTY_BUFFER, channelFuture);
                channelFuture.addListener((GenericFutureListener<? extends com.arangodb.shaded.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<com.arangodb.shaded.netty.util.concurrent.Future>)fut -> this.fail(result.cause())));
            }
        } else {
            eventLoop.execute(this::responseComplete);
        }
    }

    private void handleNext(Http1xServerRequest next) {
        this.responseInProgress = next;
        next.handleBegin(this.writable);
        next.context.emit(next, next_ -> {
            next_.resume();
            Handler<HttpServerRequest> handler = next_.nettyRequest().decoderResult().isSuccess() ? this.requestHandler : this.invalidRequestHandler;
            handler.handle((HttpServerRequest)next_);
        });
    }

    @Override
    public void doPause() {
        if (!this.channelPaused) {
            this.channelPaused = true;
            super.doPause();
        }
    }

    @Override
    public void doResume() {
        if (this.channelPaused) {
            this.channelPaused = false;
            super.doResume();
        }
    }

    private void reportResponseComplete() {
        Http1xServerRequest request = this.responseInProgress;
        if (this.metrics != null) {
            this.flushBytesWritten();
            if (this.requestFailed) {
                this.metrics.requestReset(request.metric());
                this.requestFailed = false;
            } else {
                this.metrics.responseEnd(request.metric(), request.response(), request.response().bytesWritten());
            }
        }
        VertxTracer tracer = this.context.tracer();
        Object trace = request.trace();
        if (tracer != null && trace != null) {
            tracer.sendResponse(request.context, request.response(), trace, null, HttpUtils.SERVER_RESPONSE_TAG_EXTRACTOR);
        }
    }

    String getServerOrigin() {
        return this.serverOrigin;
    }

    Vertx vertx() {
        return this.vertx;
    }

    void createWebSocket(Http1xServerRequest request, PromiseInternal<ServerWebSocket> promise) {
        this.context.execute(() -> {
            if (request != this.responseInProgress) {
                promise.fail("Invalid request");
            } else if (this.webSocket != null) {
                promise.complete((ServerWebSocket)((Object)this.webSocket));
            } else if (!(request.nettyRequest() instanceof FullHttpRequest)) {
                promise.fail(new IllegalStateException());
            } else {
                WebSocketServerHandshaker handshaker;
                try {
                    handshaker = this.createHandshaker(request);
                }
                catch (WebSocketHandshakeException e) {
                    promise.fail(e);
                    return;
                }
                this.webSocket = new ServerWebSocketImpl(promise.context(), this, handshaker.version() != WebSocketVersion.V00, this.options.getWebSocketClosingTimeout(), request, handshaker, this.options.getMaxWebSocketFrameSize(), this.options.getMaxWebSocketMessageSize(), this.options.isRegisterWebSocketWriteHandlers());
                if (Metrics.METRICS_ENABLED && this.metrics != null) {
                    ((ServerWebSocketImpl)this.webSocket).setMetric(this.metrics.connected(this.metric(), request.metric(), (ServerWebSocket)((Object)this.webSocket)));
                }
                promise.complete((ServerWebSocket)((Object)this.webSocket));
            }
        });
    }

    private WebSocketServerHandshaker createHandshaker(Http1xServerRequest request) throws WebSocketHandshakeException {
        WebSocketDecoderConfig config;
        WebSocketServerHandshakerFactory factory;
        WebSocketServerHandshaker shake;
        String wsURL;
        String connectionHeader = request.getHeader(HttpHeaders.CONNECTION);
        if (connectionHeader == null || !connectionHeader.toLowerCase().contains("upgrade")) {
            request.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("\"Connection\" header must be \"Upgrade\".");
            throw new WebSocketHandshakeException("Invalid connection header");
        }
        if (request.method() != HttpMethod.GET) {
            request.response().setStatusCode(HttpResponseStatus.METHOD_NOT_ALLOWED.code()).end();
            throw new WebSocketHandshakeException("Invalid HTTP method");
        }
        try {
            wsURL = HttpUtils.getWebSocketLocation(request, this.isSsl());
        }
        catch (Exception e) {
            request.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Invalid request URI");
            throw new WebSocketHandshakeException("Invalid WebSocket location", e);
        }
        String subProtocols = null;
        if (this.options.getWebSocketSubProtocols() != null) {
            subProtocols = String.join((CharSequence)",", this.options.getWebSocketSubProtocols());
        }
        if ((shake = (factory = new WebSocketServerHandshakerFactory(wsURL, subProtocols, config = WebSocketDecoderConfig.newBuilder().allowExtensions(this.options.getPerMessageWebSocketCompressionSupported() || this.options.getPerFrameWebSocketCompressionSupported()).maxFramePayloadLength(this.options.getMaxWebSocketFrameSize()).allowMaskMismatch(this.options.isAcceptUnmaskedFrames()).closeOnProtocolViolation(false).build())).newHandshaker(request.nettyRequest())) != null) {
            return shake;
        }
        request.response().putHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (CharSequence)WebSocketVersion.V13.toHttpHeaderValue()).setStatusCode(HttpResponseStatus.UPGRADE_REQUIRED.code()).end();
        throw new WebSocketHandshakeException("Invalid WebSocket version");
    }

    public void netSocket(Handler<AsyncResult<NetSocket>> handler) {
        Future<NetSocket> fut = this.netSocket();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    public Future<NetSocket> netSocket() {
        PromiseInternal<NetSocket> promise = this.context.promise();
        this.netSocket((Promise<NetSocket>)promise);
        return promise.future();
    }

    void netSocket(Promise<NetSocket> promise) {
        this.context.execute(() -> {
            this.flush();
            ChannelPipeline pipeline = this.chctx.pipeline();
            HttpChunkContentCompressor compressor = pipeline.get(HttpChunkContentCompressor.class);
            if (compressor != null) {
                pipeline.remove(compressor);
            }
            pipeline.remove("httpDecoder");
            if (pipeline.get("chunkedWriter") != null) {
                pipeline.remove("chunkedWriter");
            }
            pipeline.replace("handler", "handler", VertxHandler.create(ctx -> {
                NetSocketImpl socket = new NetSocketImpl(this.context, (ChannelHandlerContext)ctx, this.sslChannelProvider, this.metrics, false){

                    @Override
                    protected void handleClosed() {
                        if (Http1xServerConnection.this.metrics != null) {
                            Http1xServerRequest request = Http1xServerConnection.this.responseInProgress;
                            Http1xServerConnection.this.metrics.responseEnd(request.metric(), request.response(), request.response().bytesWritten());
                        }
                        super.handleClosed();
                    }

                    @Override
                    public synchronized void handleMessage(Object msg) {
                        if (msg instanceof HttpContent) {
                            ReferenceCountUtil.release(msg);
                            return;
                        }
                        super.handleMessage(msg);
                    }
                };
                socket.metric(this.metric());
                return socket;
            }));
            pipeline.remove("httpEncoder");
            VertxHandler handler = (VertxHandler)pipeline.get("handler");
            promise.complete((NetSocket)handler.getConnection());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInterestedOpsChanged() {
        Handler<Boolean> handler;
        ContextInternal context;
        this.writable = !this.isNotWritable();
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            if (this.responseInProgress != null) {
                context = this.responseInProgress.context;
                handler = this.responseInProgress.response()::handleWritabilityChanged;
            } else if (this.webSocket != null) {
                context = ((ServerWebSocketImpl)this.webSocket).context;
                handler = ((ServerWebSocketImpl)this.webSocket)::handleWritabilityChanged;
            } else {
                return;
            }
        }
        context.execute(this.writable, handler);
    }

    void write100Continue() {
        this.chctx.writeAndFlush(new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
    }

    void write103EarlyHints(com.arangodb.shaded.netty.handler.codec.http.HttpHeaders headers, PromiseInternal<Void> promise) {
        this.chctx.writeAndFlush(new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.EARLY_HINTS, Unpooled.buffer(0), headers, EmptyHttpHeaders.INSTANCE)).addListener((GenericFutureListener<? extends com.arangodb.shaded.netty.util.concurrent.Future<? super Void>>)promise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClosed() {
        Http1xServerRequest responseInProgress;
        Http1xServerRequest requestInProgress;
        ServerWebSocketImpl ws;
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            ws = (ServerWebSocketImpl)this.webSocket;
            requestInProgress = this.requestInProgress;
            responseInProgress = this.responseInProgress;
        }
        if (requestInProgress != null) {
            requestInProgress.context.execute(v -> requestInProgress.handleException(HttpUtils.CONNECTION_CLOSED_EXCEPTION));
        }
        if (responseInProgress != null && responseInProgress != requestInProgress) {
            responseInProgress.context.execute(v -> responseInProgress.handleException(HttpUtils.CONNECTION_CLOSED_EXCEPTION));
        }
        if (ws != null) {
            ws.context.execute(v -> ws.handleConnectionClosed());
        }
        super.handleClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleException(Throwable t) {
        Http1xServerRequest responseInProgress;
        Http1xServerRequest requestInProgress;
        ServerWebSocketImpl ws;
        super.handleException(t);
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            ws = (ServerWebSocketImpl)this.webSocket;
            requestInProgress = this.requestInProgress;
            responseInProgress = this.responseInProgress;
            if (Metrics.METRICS_ENABLED && this.metrics != null) {
                this.requestFailed = true;
            }
        }
        if (requestInProgress != null) {
            requestInProgress.handleException(t);
        }
        if (responseInProgress != null && responseInProgress != requestInProgress) {
            responseInProgress.handleException(t);
        }
        if (ws != null) {
            ws.context.execute(v -> ws.handleException(t));
        }
    }

    @Override
    protected boolean supportsFileRegion() {
        return super.supportsFileRegion() && this.chctx.pipeline().get(HttpChunkContentCompressor.class) == null;
    }

    private void handleError(HttpObject obj) {
        DecoderResult result = obj.decoderResult();
        ReferenceCountUtil.release(obj);
        this.fail(result.cause());
    }
}

