/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.http.impl;

import com.arangodb.shaded.netty.buffer.ByteBuf;
import com.arangodb.shaded.netty.buffer.Unpooled;
import com.arangodb.shaded.netty.channel.ChannelHandlerContext;
import com.arangodb.shaded.netty.channel.ChannelInboundHandlerAdapter;
import com.arangodb.shaded.netty.channel.ChannelPipeline;
import com.arangodb.shaded.netty.handler.codec.http.DefaultFullHttpResponse;
import com.arangodb.shaded.netty.handler.codec.http.HttpContent;
import com.arangodb.shaded.netty.handler.codec.http.HttpHeaderNames;
import com.arangodb.shaded.netty.handler.codec.http.HttpHeaderValidationUtil;
import com.arangodb.shaded.netty.handler.codec.http.HttpHeaderValues;
import com.arangodb.shaded.netty.handler.codec.http.HttpRequest;
import com.arangodb.shaded.netty.handler.codec.http.HttpResponseStatus;
import com.arangodb.shaded.netty.handler.codec.http.HttpVersion;
import com.arangodb.shaded.netty.handler.codec.http.LastHttpContent;
import com.arangodb.shaded.netty.handler.codec.http2.DefaultHttp2DataFrame;
import com.arangodb.shaded.netty.handler.codec.http2.DefaultHttp2Headers;
import com.arangodb.shaded.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import com.arangodb.shaded.netty.handler.codec.http2.Http2CodecUtil;
import com.arangodb.shaded.netty.handler.codec.http2.Http2ConnectionHandler;
import com.arangodb.shaded.netty.handler.codec.http2.Http2Settings;
import com.arangodb.shaded.netty.handler.timeout.IdleState;
import com.arangodb.shaded.netty.handler.timeout.IdleStateEvent;
import com.arangodb.shaded.vertx.core.http.HttpHeaders;
import com.arangodb.shaded.vertx.core.http.impl.Http2ServerConnection;
import com.arangodb.shaded.vertx.core.http.impl.HttpServerImpl;
import com.arangodb.shaded.vertx.core.http.impl.HttpServerWorker;
import com.arangodb.shaded.vertx.core.http.impl.HttpUtils;
import com.arangodb.shaded.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import com.arangodb.shaded.vertx.core.net.impl.SslChannelProvider;
import com.arangodb.shaded.vertx.core.net.impl.VertxHandler;
import java.util.Map;

public class Http1xUpgradeToH2CHandler
extends ChannelInboundHandlerAdapter {
    private final HttpServerWorker initializer;
    private final SslChannelProvider sslChannelProvider;
    private VertxHttp2ConnectionHandler<Http2ServerConnection> handler;
    private final boolean isCompressionSupported;
    private final boolean isDecompressionSupported;

    Http1xUpgradeToH2CHandler(HttpServerWorker initializer, SslChannelProvider sslChannelProvider, boolean isCompressionSupported, boolean isDecompressionSupported) {
        this.initializer = initializer;
        this.sslChannelProvider = sslChannelProvider;
        this.isCompressionSupported = isCompressionSupported;
        this.isDecompressionSupported = isDecompressionSupported;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            if (request.headers().contains(HttpHeaders.UPGRADE, Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, true)) {
                Http2Settings settings;
                String settingsHeader;
                String connection = request.headers().get(HttpHeaders.CONNECTION);
                int found = 0;
                if (connection != null && connection.length() > 0) {
                    StringBuilder buff = new StringBuilder();
                    int pos = 0;
                    int len = connection.length();
                    while (pos < len) {
                        char c;
                        if ((c = connection.charAt(pos++)) != ' ' && c != ',') {
                            buff.append(Character.toLowerCase(c));
                        }
                        if (c != ',' && pos != len) continue;
                        if (buff.indexOf("upgrade") == 0 && buff.length() == 7) {
                            found |= 1;
                        } else if (buff.indexOf("http2-settings") == 0 && buff.length() == 14) {
                            found |= 2;
                        }
                        buff.setLength(0);
                    }
                }
                if (found == 3 && (settingsHeader = request.headers().get(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER)) != null && (settings = HttpUtils.decodeSettings(settingsHeader)) != null) {
                    if (this.initializer.context.isEventLoopContext()) {
                        ChannelPipeline pipeline = ctx.pipeline();
                        if (pipeline.get("chunkedWriter") != null) {
                            pipeline.remove("chunkedWriter");
                        }
                        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, Unpooled.EMPTY_BUFFER, false);
                        res.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
                        res.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME);
                        ctx.write(res);
                        pipeline.remove("httpEncoder");
                        if (this.isCompressionSupported) {
                            pipeline.remove("deflater");
                        }
                        if (this.isDecompressionSupported) {
                            pipeline.remove("inflater");
                        }
                        this.handler = this.initializer.buildHttp2ConnectionHandler(this.initializer.context, this.initializer.connectionHandler);
                        pipeline.addLast("handler", this.handler);
                        this.handler.serverUpgrade(ctx, settings);
                        DefaultHttp2Headers headers = new DefaultHttp2Headers();
                        headers.method(request.method().name());
                        headers.path(request.uri());
                        headers.authority(request.headers().get("host"));
                        headers.scheme("http");
                        request.headers().remove("http2-settings");
                        request.headers().remove("host");
                        request.headers().forEach(header -> {
                            if (!HttpHeaderValidationUtil.isConnectionHeader((CharSequence)header.getKey(), true)) {
                                headers.set(((String)header.getKey()).toLowerCase(), header.getValue());
                            }
                        });
                        ctx.fireChannelRead(new DefaultHttp2HeadersFrame(headers, false));
                    } else {
                        HttpServerImpl.log.warn("Cannot perform HTTP/2 upgrade in a worker verticle");
                    }
                }
                if (this.handler == null) {
                    DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, Unpooled.EMPTY_BUFFER, false);
                    res.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                    ctx.writeAndFlush(res);
                }
            } else {
                this.initializer.configureHttp1(ctx.pipeline(), this.sslChannelProvider);
                ctx.fireChannelRead(msg);
                ctx.pipeline().remove(this);
            }
        } else if (this.handler != null) {
            if (msg instanceof HttpContent) {
                HttpContent content = (HttpContent)msg;
                ByteBuf buf = VertxHandler.safeBuffer(content.content());
                boolean end = msg instanceof LastHttpContent;
                ctx.fireChannelRead(new DefaultHttp2DataFrame(buf, end, 0));
                if (end) {
                    ChannelPipeline pipeline = ctx.pipeline();
                    for (Map.Entry handler : pipeline) {
                        if (handler.getValue() instanceof Http2ConnectionHandler) continue;
                        pipeline.remove((String)handler.getKey());
                    }
                    this.initializer.configureHttp2(pipeline);
                }
            } else {
                super.channelRead(ctx, msg);
            }
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.ALL_IDLE) {
            ctx.close();
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }
}

