/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.http.impl;

import com.arangodb.shaded.netty.buffer.ByteBuf;
import com.arangodb.shaded.netty.channel.ChannelHandlerContext;
import com.arangodb.shaded.netty.channel.ChannelPromise;
import com.arangodb.shaded.netty.handler.codec.compression.CompressionOptions;
import com.arangodb.shaded.netty.handler.codec.http.DefaultHttpContent;
import com.arangodb.shaded.netty.handler.codec.http.HttpContentCompressor;
import com.arangodb.shaded.netty.handler.codec.http.HttpContentEncoder;
import com.arangodb.shaded.netty.handler.codec.http.HttpHeaderNames;
import com.arangodb.shaded.netty.handler.codec.http.HttpResponse;

final class HttpChunkContentCompressor
extends HttpContentCompressor {
    public HttpChunkContentCompressor(CompressionOptions ... compressionOptions) {
        super(0, compressionOptions);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ByteBuf buff;
        if (msg instanceof ByteBuf && (buff = (ByteBuf)msg).isReadable()) {
            msg = new DefaultHttpContent(buff);
        }
        super.write(ctx, msg, promise);
    }

    @Override
    protected HttpContentEncoder.Result beginEncode(HttpResponse httpResponse, String acceptEncoding) throws Exception {
        HttpContentEncoder.Result result = super.beginEncode(httpResponse, acceptEncoding);
        if (result == null && httpResponse.headers().contains(HttpHeaderNames.CONTENT_ENCODING, (CharSequence)"identity", true)) {
            httpResponse.headers().remove(HttpHeaderNames.CONTENT_ENCODING);
        }
        return result;
    }
}

