/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.http.impl;

import com.arangodb.shaded.netty.handler.codec.http2.Http2Error;
import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.Promise;
import com.arangodb.shaded.vertx.core.http.HttpClientRequest;
import com.arangodb.shaded.vertx.core.http.HttpClientResponse;
import com.arangodb.shaded.vertx.core.http.HttpMethod;
import com.arangodb.shaded.vertx.core.http.StreamResetException;
import com.arangodb.shaded.vertx.core.http.impl.HttpClientImpl;
import com.arangodb.shaded.vertx.core.http.impl.HttpClientPush;
import com.arangodb.shaded.vertx.core.http.impl.HttpClientRequestPushPromise;
import com.arangodb.shaded.vertx.core.http.impl.HttpClientResponseImpl;
import com.arangodb.shaded.vertx.core.http.impl.HttpClientStream;
import com.arangodb.shaded.vertx.core.http.impl.HttpUtils;
import com.arangodb.shaded.vertx.core.http.impl.NoStackTraceTimeoutException;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import com.arangodb.shaded.vertx.core.impl.future.PromiseInternal;
import com.arangodb.shaded.vertx.core.net.SocketAddress;
import java.util.Objects;

public abstract class HttpClientRequestBase
implements HttpClientRequest {
    protected final HttpClientImpl client;
    protected final ContextInternal context;
    protected final HttpClientStream stream;
    protected final SocketAddress server;
    protected final boolean ssl;
    private HttpMethod method;
    private String host;
    private int port;
    private String uri;
    private String path;
    private String query;
    private final PromiseInternal<HttpClientResponse> responsePromise;
    private Handler<HttpClientRequest> pushHandler;
    private long currentTimeoutTimerId = -1L;
    private long currentTimeoutMs;
    private long lastDataReceived;

    HttpClientRequestBase(HttpClientImpl client, HttpClientStream stream, PromiseInternal<HttpClientResponse> responsePromise, boolean ssl, HttpMethod method, SocketAddress server, String host, int port, String uri) {
        this.client = client;
        this.stream = stream;
        this.responsePromise = responsePromise;
        this.context = responsePromise.context();
        this.uri = uri;
        this.method = method;
        this.server = server;
        this.host = host;
        this.port = port;
        this.ssl = ssl;
        stream.pushHandler(this::handlePush);
        stream.headHandler(resp -> {
            HttpClientResponseImpl response = new HttpClientResponseImpl(this, stream.version(), stream, resp.statusCode, resp.statusMessage, resp.headers);
            stream.chunkHandler(response::handleChunk);
            stream.endHandler(response::handleEnd);
            stream.priorityHandler(response::handlePriorityChange);
            stream.unknownFrameHandler(response::handleUnknownFrame);
            this.handleResponse(response);
        });
    }

    protected String authority() {
        if (this.port == 80 && !this.ssl || this.port == 443 && this.ssl) {
            return this.host;
        }
        return this.host + ':' + this.port;
    }

    @Override
    public int streamId() {
        return this.stream.id();
    }

    @Override
    public String absoluteURI() {
        return (this.ssl ? "https://" : "http://") + this.authority() + this.uri;
    }

    @Override
    public String query() {
        if (this.query == null) {
            this.query = HttpUtils.parseQuery(this.uri);
        }
        return this.query;
    }

    @Override
    public String path() {
        if (this.path == null) {
            this.path = HttpUtils.parsePath(this.uri);
        }
        return this.path;
    }

    @Override
    public synchronized String getURI() {
        return this.uri;
    }

    @Override
    public synchronized HttpClientRequest setURI(String uri) {
        Objects.requireNonNull(uri);
        this.uri = uri;
        this.path = null;
        this.query = null;
        return this;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public synchronized HttpClientRequest setHost(String host) {
        Objects.requireNonNull(this.uri);
        this.host = host;
        return this;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public synchronized HttpClientRequest setPort(int port) {
        this.port = port;
        return this;
    }

    @Override
    public synchronized HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public synchronized HttpClientRequest setMethod(HttpMethod method) {
        Objects.requireNonNull(this.uri);
        this.method = method;
        return this;
    }

    @Override
    public synchronized HttpClientRequest setTimeout(long timeoutMs) {
        this.cancelTimeout();
        this.currentTimeoutMs = timeoutMs;
        this.currentTimeoutTimerId = this.context.setTimer(timeoutMs, id -> this.handleTimeout(timeoutMs));
        return this;
    }

    void handleException(Throwable t) {
        this.fail(t);
    }

    void fail(Throwable t) {
        this.cancelTimeout();
        this.responsePromise.tryFail(t);
        HttpClientResponseImpl response = (HttpClientResponseImpl)this.responsePromise.future().result();
        if (response != null) {
            response.handleException(t);
        }
    }

    void handlePush(HttpClientPush push) {
        HttpClientRequestPushPromise pushReq = new HttpClientRequestPushPromise(push.stream, this.client, this.ssl, push.method, push.uri, push.host, push.port, push.headers);
        if (this.pushHandler != null) {
            this.pushHandler.handle(pushReq);
        } else {
            pushReq.reset(Http2Error.CANCEL.code());
        }
    }

    void handleResponse(HttpClientResponse resp) {
        this.handleResponse(this.responsePromise, resp, this.cancelTimeout());
    }

    abstract void handleResponse(Promise<HttpClientResponse> var1, HttpClientResponse var2, long var3);

    private synchronized long cancelTimeout() {
        long ret = this.currentTimeoutTimerId;
        if (ret != -1L) {
            this.client.vertx().cancelTimer(this.currentTimeoutTimerId);
            this.currentTimeoutTimerId = -1L;
            ret = this.currentTimeoutMs;
            this.currentTimeoutMs = 0L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTimeout(long timeoutMs) {
        HttpClientRequestBase httpClientRequestBase = this;
        synchronized (httpClientRequestBase) {
            long now;
            long timeSinceLastData;
            this.currentTimeoutTimerId = -1L;
            this.currentTimeoutMs = 0L;
            if (this.lastDataReceived > 0L && (timeSinceLastData = (now = System.currentTimeMillis()) - this.lastDataReceived) < timeoutMs) {
                this.lastDataReceived = 0L;
                this.setTimeout(timeoutMs - timeSinceLastData);
                return;
            }
        }
        this.reset(HttpClientRequestBase.timeoutEx(timeoutMs, this.method, this.server, this.uri));
    }

    static NoStackTraceTimeoutException timeoutEx(long timeoutMs, HttpMethod method, SocketAddress server, String uri) {
        return new NoStackTraceTimeoutException("The timeout period of " + timeoutMs + "ms has been exceeded while executing " + method + " " + uri + " for server " + server);
    }

    synchronized void dataReceived() {
        if (this.currentTimeoutTimerId != -1L) {
            this.lastDataReceived = System.currentTimeMillis();
        }
    }

    @Override
    public boolean reset(long code) {
        return this.reset(new StreamResetException(code));
    }

    @Override
    public boolean reset(long code, Throwable cause) {
        return this.reset(new StreamResetException(code, cause));
    }

    abstract boolean reset(Throwable var1);

    @Override
    public HttpClientRequest response(Handler<AsyncResult<HttpClientResponse>> handler) {
        this.responsePromise.future().onComplete(handler);
        return this;
    }

    @Override
    public Future<HttpClientResponse> response() {
        return this.responsePromise.future();
    }

    synchronized Handler<HttpClientRequest> pushHandler() {
        return this.pushHandler;
    }

    @Override
    public synchronized HttpClientRequest pushHandler(Handler<HttpClientRequest> handler) {
        this.pushHandler = handler;
        return this;
    }
}

