/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.http.impl;

import com.arangodb.shaded.netty.buffer.Unpooled;
import com.arangodb.shaded.netty.channel.Channel;
import com.arangodb.shaded.netty.channel.ChannelFutureListener;
import com.arangodb.shaded.netty.channel.ChannelHandler;
import com.arangodb.shaded.netty.channel.ChannelHandlerContext;
import com.arangodb.shaded.netty.channel.ChannelPipeline;
import com.arangodb.shaded.netty.channel.ChannelPromise;
import com.arangodb.shaded.netty.handler.codec.compression.CompressionOptions;
import com.arangodb.shaded.netty.handler.codec.compression.StandardCompressionOptions;
import com.arangodb.shaded.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import com.arangodb.shaded.netty.handler.codec.http.HttpContentCompressor;
import com.arangodb.shaded.netty.handler.codec.http.HttpContentDecompressor;
import com.arangodb.shaded.netty.handler.codec.http2.Http2ConnectionHandler;
import com.arangodb.shaded.netty.handler.logging.LoggingHandler;
import com.arangodb.shaded.netty.handler.ssl.SslHandler;
import com.arangodb.shaded.netty.handler.stream.ChunkedWriteHandler;
import com.arangodb.shaded.netty.handler.timeout.IdleState;
import com.arangodb.shaded.netty.handler.timeout.IdleStateEvent;
import com.arangodb.shaded.netty.handler.timeout.IdleStateHandler;
import com.arangodb.shaded.netty.util.concurrent.Future;
import com.arangodb.shaded.netty.util.concurrent.GenericFutureListener;
import com.arangodb.shaded.netty.util.concurrent.Promise;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.http.HttpServerOptions;
import com.arangodb.shaded.vertx.core.http.impl.Http1xOrH2CHandler;
import com.arangodb.shaded.vertx.core.http.impl.Http1xServerConnection;
import com.arangodb.shaded.vertx.core.http.impl.Http1xUpgradeToH2CHandler;
import com.arangodb.shaded.vertx.core.http.impl.Http2ServerConnection;
import com.arangodb.shaded.vertx.core.http.impl.HttpChunkContentCompressor;
import com.arangodb.shaded.vertx.core.http.impl.HttpServerConnection;
import com.arangodb.shaded.vertx.core.http.impl.HttpServerImpl;
import com.arangodb.shaded.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import com.arangodb.shaded.vertx.core.http.impl.VertxHttp2ConnectionHandlerBuilder;
import com.arangodb.shaded.vertx.core.http.impl.VertxHttpRequestDecoder;
import com.arangodb.shaded.vertx.core.http.impl.VertxHttpResponseEncoder;
import com.arangodb.shaded.vertx.core.http.impl.cgbystrom.FlashPolicyHandler;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import com.arangodb.shaded.vertx.core.impl.EventLoopContext;
import com.arangodb.shaded.vertx.core.impl.VertxInternal;
import com.arangodb.shaded.vertx.core.net.impl.HAProxyMessageCompletionHandler;
import com.arangodb.shaded.vertx.core.net.impl.SslChannelProvider;
import com.arangodb.shaded.vertx.core.net.impl.SslHandshakeCompletionHandler;
import com.arangodb.shaded.vertx.core.net.impl.VertxHandler;
import com.arangodb.shaded.vertx.core.spi.metrics.HttpServerMetrics;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class HttpServerWorker
implements BiConsumer<Channel, SslChannelProvider> {
    final EventLoopContext context;
    private final Supplier<ContextInternal> streamContextSupplier;
    private final VertxInternal vertx;
    private final HttpServerImpl server;
    private final HttpServerOptions options;
    private final String serverOrigin;
    private final boolean logEnabled;
    private final boolean disableH2C;
    final Handler<HttpServerConnection> connectionHandler;
    private final Handler<Throwable> exceptionHandler;
    private final CompressionOptions[] compressionOptions;
    private final Function<String, String> encodingDetector;

    public HttpServerWorker(EventLoopContext context, Supplier<ContextInternal> streamContextSupplier, HttpServerImpl server, VertxInternal vertx, HttpServerOptions options, String serverOrigin, boolean disableH2C, Handler<HttpServerConnection> connectionHandler, Handler<Throwable> exceptionHandler) {
        CompressionOptions[] compressionOptions = null;
        if (options.isCompressionSupported()) {
            List<CompressionOptions> compressors = options.getCompressors();
            if (compressors == null) {
                int compressionLevel = options.getCompressionLevel();
                compressionOptions = new CompressionOptions[]{StandardCompressionOptions.gzip(compressionLevel, 15, 8), StandardCompressionOptions.deflate(compressionLevel, 15, 8)};
            } else {
                compressionOptions = compressors.toArray(new CompressionOptions[0]);
            }
        }
        this.context = context;
        this.streamContextSupplier = streamContextSupplier;
        this.server = server;
        this.vertx = vertx;
        this.options = options;
        this.serverOrigin = serverOrigin;
        this.logEnabled = options.getLogActivity();
        this.disableH2C = disableH2C;
        this.connectionHandler = connectionHandler;
        this.exceptionHandler = exceptionHandler;
        this.compressionOptions = compressionOptions;
        this.encodingDetector = compressionOptions != null ? new EncodingDetector(compressionOptions)::determineEncoding : null;
    }

    @Override
    public void accept(Channel ch, SslChannelProvider sslChannelProvider) {
        if (HAProxyMessageCompletionHandler.canUseProxyProtocol(this.options.isUseProxyProtocol())) {
            IdleStateHandler idle;
            Promise<Channel> p = ch.eventLoop().newPromise();
            ch.pipeline().addLast(new ChannelHandler[]{new HAProxyMessageDecoder()});
            if (this.options.getProxyProtocolTimeout() > 0L) {
                idle = new IdleStateHandler(0L, 0L, this.options.getProxyProtocolTimeout(), this.options.getProxyProtocolTimeoutUnit());
                ch.pipeline().addLast("idle", (ChannelHandler)idle);
            } else {
                idle = null;
            }
            ch.pipeline().addLast(new HAProxyMessageCompletionHandler(p));
            p.addListener(future -> {
                if (future.isSuccess()) {
                    if (idle != null) {
                        ch.pipeline().remove(idle);
                    }
                    this.configurePipeline((Channel)future.getNow(), sslChannelProvider);
                } else {
                    this.handleException(future.cause());
                }
            });
        } else {
            this.configurePipeline(ch, sslChannelProvider);
        }
    }

    private void configurePipeline(final Channel ch, final SslChannelProvider sslChannelProvider) {
        final ChannelPipeline pipeline = ch.pipeline();
        if (this.options.isSsl()) {
            pipeline.addLast("ssl", sslChannelProvider.createServerHandler());
            ChannelPromise p = ch.newPromise();
            pipeline.addLast("handshaker", (ChannelHandler)new SslHandshakeCompletionHandler(p));
            p.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (future.isSuccess()) {
                    if (this.options.isUseAlpn()) {
                        SslHandler sslHandler = pipeline.get(SslHandler.class);
                        String protocol = sslHandler.applicationProtocol();
                        if ("h2".equals(protocol)) {
                            this.handleHttp2(ch);
                        } else {
                            this.handleHttp1(ch, sslChannelProvider);
                        }
                    } else {
                        this.handleHttp1(ch, sslChannelProvider);
                    }
                } else {
                    this.handleException(future.cause());
                }
            }));
        } else if (this.disableH2C) {
            this.handleHttp1(ch, sslChannelProvider);
        } else {
            IdleStateHandler idle;
            int idleTimeout = this.options.getIdleTimeout();
            int readIdleTimeout = this.options.getReadIdleTimeout();
            int writeIdleTimeout = this.options.getWriteIdleTimeout();
            if (idleTimeout > 0 || readIdleTimeout > 0 || writeIdleTimeout > 0) {
                idle = new IdleStateHandler(readIdleTimeout, writeIdleTimeout, idleTimeout, this.options.getIdleTimeoutUnit());
                pipeline.addLast("idle", (ChannelHandler)idle);
            } else {
                idle = null;
            }
            pipeline.addLast(new Http1xOrH2CHandler(){

                @Override
                protected void configure(ChannelHandlerContext ctx, boolean h2c) {
                    if (idle != null) {
                        pipeline.remove(idle);
                    }
                    if (h2c) {
                        HttpServerWorker.this.handleHttp2(ctx.channel());
                    } else {
                        HttpServerWorker.this.handleHttp1(ch, sslChannelProvider);
                    }
                }

                @Override
                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                    if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.ALL_IDLE) {
                        ctx.close();
                    }
                }

                @Override
                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    super.exceptionCaught(ctx, cause);
                    HttpServerWorker.this.handleException(cause);
                }
            });
        }
    }

    private void handleException(Throwable cause) {
        this.context.emit(cause, this.exceptionHandler);
    }

    private void handleHttp1(Channel ch, SslChannelProvider sslChannelProvider) {
        this.configureHttp1OrH2C(ch.pipeline(), sslChannelProvider);
    }

    private void sendServiceUnavailable(Channel ch) {
        ch.writeAndFlush(Unpooled.copiedBuffer("HTTP/1.1 503 Service Unavailable\r\nContent-Length:0\r\n\r\n", StandardCharsets.ISO_8859_1)).addListener(ChannelFutureListener.CLOSE);
    }

    private void handleHttp2(Channel ch) {
        VertxHttp2ConnectionHandler<Http2ServerConnection> handler = this.buildHttp2ConnectionHandler(this.context, this.connectionHandler);
        ch.pipeline().addLast("handler", handler);
        this.configureHttp2(ch.pipeline());
    }

    void configureHttp2(ChannelPipeline pipeline) {
        if (!this.server.requestAccept()) {
            pipeline.channel().close();
            return;
        }
        int idleTimeout = this.options.getIdleTimeout();
        int readIdleTimeout = this.options.getReadIdleTimeout();
        int writeIdleTimeout = this.options.getWriteIdleTimeout();
        if (idleTimeout > 0 || readIdleTimeout > 0 || writeIdleTimeout > 0) {
            pipeline.addBefore("handler", "idle", new IdleStateHandler(readIdleTimeout, writeIdleTimeout, idleTimeout, this.options.getIdleTimeoutUnit()));
        }
    }

    VertxHttp2ConnectionHandler<Http2ServerConnection> buildHttp2ConnectionHandler(EventLoopContext ctx, Handler<HttpServerConnection> handler_) {
        HttpServerMetrics metrics = (HttpServerMetrics)this.server.getMetrics();
        Http2ConnectionHandler handler = ((VertxHttp2ConnectionHandlerBuilder)new VertxHttp2ConnectionHandlerBuilder().server(true)).useCompression(this.compressionOptions).useDecompression(this.options.isDecompressionSupported()).initialSettings(this.options.getInitialSettings()).connectionFactory(connHandler -> {
            Http2ServerConnection conn = new Http2ServerConnection(ctx, this.streamContextSupplier, this.serverOrigin, (VertxHttp2ConnectionHandler)connHandler, this.encodingDetector, this.options, metrics);
            if (metrics != null) {
                conn.metric(metrics.connected(conn.remoteAddress(), conn.remoteName()));
            }
            return conn;
        }).logEnabled(this.logEnabled).build();
        ((VertxHttp2ConnectionHandler)handler).addHandler(conn -> {
            if (this.options.getHttp2ConnectionWindowSize() > 0) {
                conn.setWindowSize(this.options.getHttp2ConnectionWindowSize());
            }
            handler_.handle((HttpServerConnection)conn);
        });
        return handler;
    }

    private void configureHttp1OrH2C(ChannelPipeline pipeline, SslChannelProvider sslChannelProvider) {
        if (this.logEnabled) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler(this.options.getActivityLogDataFormat()));
        }
        if (HttpServerImpl.USE_FLASH_POLICY_HANDLER) {
            pipeline.addLast("flashpolicy", (ChannelHandler)new FlashPolicyHandler());
        }
        pipeline.addLast("httpDecoder", (ChannelHandler)new VertxHttpRequestDecoder(this.options));
        pipeline.addLast("httpEncoder", (ChannelHandler)new VertxHttpResponseEncoder());
        if (this.options.isDecompressionSupported()) {
            pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor(false));
        }
        if (this.options.isCompressionSupported()) {
            pipeline.addLast("deflater", (ChannelHandler)new HttpChunkContentCompressor(this.compressionOptions));
        }
        if (this.options.isSsl() || this.options.isCompressionSupported() || !this.vertx.transport().supportFileRegion()) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        int idleTimeout = this.options.getIdleTimeout();
        int readIdleTimeout = this.options.getReadIdleTimeout();
        int writeIdleTimeout = this.options.getWriteIdleTimeout();
        if (idleTimeout > 0 || readIdleTimeout > 0 || writeIdleTimeout > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(readIdleTimeout, writeIdleTimeout, idleTimeout, this.options.getIdleTimeoutUnit()));
        }
        if (this.disableH2C) {
            this.configureHttp1(pipeline, sslChannelProvider);
        } else {
            pipeline.addLast("h2c", (ChannelHandler)new Http1xUpgradeToH2CHandler(this, sslChannelProvider, this.options.isCompressionSupported(), this.options.isDecompressionSupported()));
        }
    }

    void configureHttp1(ChannelPipeline pipeline, SslChannelProvider sslChannelProvider) {
        if (!this.server.requestAccept()) {
            this.sendServiceUnavailable(pipeline.channel());
            return;
        }
        HttpServerMetrics metrics = (HttpServerMetrics)this.server.getMetrics();
        VertxHandler<Http1xServerConnection> handler = VertxHandler.create(chctx -> {
            Http1xServerConnection conn = new Http1xServerConnection(this.streamContextSupplier, sslChannelProvider, this.options, (ChannelHandlerContext)chctx, this.context, this.serverOrigin, metrics);
            return conn;
        });
        pipeline.addLast("handler", handler);
        Http1xServerConnection conn = handler.getConnection();
        if (metrics != null) {
            conn.metric(metrics.connected(conn.remoteAddress(), conn.remoteName()));
        }
        this.connectionHandler.handle(conn);
    }

    private static class EncodingDetector
    extends HttpContentCompressor {
        private EncodingDetector(CompressionOptions[] compressionOptions) {
            super(compressionOptions);
        }

        @Override
        protected String determineEncoding(String acceptEncoding) {
            return super.determineEncoding(acceptEncoding);
        }
    }
}

