/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.http.impl;

import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.http.HttpConnection;
import com.arangodb.shaded.vertx.core.http.HttpVersion;
import com.arangodb.shaded.vertx.core.http.impl.ClientHttpEndpointBase;
import com.arangodb.shaded.vertx.core.http.impl.Http1xClientConnection;
import com.arangodb.shaded.vertx.core.http.impl.HttpChannelConnector;
import com.arangodb.shaded.vertx.core.http.impl.HttpClientConnection;
import com.arangodb.shaded.vertx.core.http.impl.HttpClientImpl;
import com.arangodb.shaded.vertx.core.http.impl.NoStackTraceTimeoutException;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import com.arangodb.shaded.vertx.core.impl.EventLoopContext;
import com.arangodb.shaded.vertx.core.net.impl.pool.ConnectResult;
import com.arangodb.shaded.vertx.core.net.impl.pool.ConnectionPool;
import com.arangodb.shaded.vertx.core.net.impl.pool.Lease;
import com.arangodb.shaded.vertx.core.net.impl.pool.PoolConnection;
import com.arangodb.shaded.vertx.core.net.impl.pool.PoolConnector;
import com.arangodb.shaded.vertx.core.net.impl.pool.PoolWaiter;
import com.arangodb.shaded.vertx.core.spi.metrics.ClientMetrics;
import java.util.List;
import java.util.function.BiFunction;

class SharedClientHttpStreamEndpoint
extends ClientHttpEndpointBase<Lease<HttpClientConnection>>
implements PoolConnector<HttpClientConnection> {
    private static final BiFunction<PoolWaiter<HttpClientConnection>, List<PoolConnection<HttpClientConnection>>, PoolConnection<HttpClientConnection>> LIFO_SELECTOR = (waiter, connections) -> {
        int size = connections.size();
        PoolConnection selected = null;
        long last = 0L;
        for (int i = 0; i < size; ++i) {
            PoolConnection pooled = (PoolConnection)connections.get(i);
            if (pooled.available() <= 0L) continue;
            HttpClientConnection conn = (HttpClientConnection)pooled.get();
            if (selected == null) {
                selected = pooled;
                continue;
            }
            if (conn.lastResponseReceivedTimestamp() <= last) continue;
            selected = pooled;
        }
        return selected;
    };
    private final HttpClientImpl client;
    private final HttpChannelConnector connector;
    private final ConnectionPool<HttpClientConnection> pool;

    public SharedClientHttpStreamEndpoint(HttpClientImpl client, ClientMetrics metrics, int queueMaxSize, int http1MaxSize, int http2MaxSize, HttpChannelConnector connector, Runnable dispose) {
        super(metrics, dispose);
        ConnectionPool<HttpClientConnection> pool = ConnectionPool.pool(this, new int[]{http1MaxSize, http2MaxSize}, queueMaxSize).connectionSelector(LIFO_SELECTOR).contextProvider(client.contextProvider());
        this.client = client;
        this.connector = connector;
        this.pool = pool;
    }

    @Override
    public void connect(EventLoopContext context, PoolConnector.Listener listener, Handler<AsyncResult<ConnectResult<HttpClientConnection>>> handler) {
        this.connector.httpConnect(context, ar -> {
            if (ar.succeeded()) {
                this.incRefCount();
                HttpClientConnection connection = (HttpClientConnection)ar.result();
                connection.evictionHandler(v -> {
                    this.decRefCount();
                    listener.onRemove();
                });
                connection.concurrencyChangeHandler(listener::onConcurrencyChange);
                long capacity = connection.concurrency();
                Handler<HttpConnection> connectionHandler = this.client.connectionHandler();
                if (connectionHandler != null) {
                    context.emit(connection, connectionHandler);
                }
                int idx = connection instanceof Http1xClientConnection ? 0 : 1;
                handler.handle(Future.succeededFuture(new ConnectResult<HttpClientConnection>(connection, capacity, idx)));
            } else {
                handler.handle(Future.failedFuture(ar.cause()));
            }
        });
    }

    @Override
    public boolean isValid(HttpClientConnection connection) {
        return connection.isValid();
    }

    @Override
    void checkExpired() {
        this.pool.evict(conn -> !conn.isValid(), ar -> {
            if (ar.succeeded()) {
                List lst = (List)ar.result();
                lst.forEach(HttpConnection::close);
            }
        });
    }

    @Override
    public void requestConnection2(ContextInternal ctx, long timeout, Handler<AsyncResult<Lease<HttpClientConnection>>> handler) {
        Request request = new Request(ctx, this.client.options().getProtocolVersion(), timeout, handler);
        request.acquire();
    }

    private class Request
    implements PoolWaiter.Listener<HttpClientConnection>,
    Handler<AsyncResult<Lease<HttpClientConnection>>> {
        private final ContextInternal context;
        private final HttpVersion protocol;
        private final long timeout;
        private final Handler<AsyncResult<Lease<HttpClientConnection>>> handler;
        private long timerID;

        Request(ContextInternal context, HttpVersion protocol, long timeout, Handler<AsyncResult<Lease<HttpClientConnection>>> handler) {
            this.context = context;
            this.protocol = protocol;
            this.timeout = timeout;
            this.handler = handler;
            this.timerID = -1L;
        }

        @Override
        public void onEnqueue(PoolWaiter<HttpClientConnection> waiter) {
            this.onConnect(waiter);
        }

        @Override
        public void onConnect(PoolWaiter<HttpClientConnection> waiter) {
            if (this.timeout > 0L && this.timerID == -1L) {
                this.timerID = this.context.setTimer(this.timeout, id -> SharedClientHttpStreamEndpoint.this.pool.cancel(waiter, ar -> {
                    if (ar.succeeded() && ((Boolean)ar.result()).booleanValue()) {
                        this.handler.handle(Future.failedFuture(new NoStackTraceTimeoutException("The timeout of " + this.timeout + " ms has been exceeded when getting a connection to " + SharedClientHttpStreamEndpoint.this.connector.server())));
                    }
                }));
            }
        }

        @Override
        public void handle(AsyncResult<Lease<HttpClientConnection>> ar) {
            if (this.timerID >= 0L) {
                this.context.owner().cancelTimer(this.timerID);
            }
            this.handler.handle(ar);
        }

        void acquire() {
            SharedClientHttpStreamEndpoint.this.pool.acquire(this.context, this, this.protocol == HttpVersion.HTTP_2 ? 1 : 0, this);
        }
    }
}

