/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.http.impl.cgbystrom;

import com.arangodb.shaded.netty.buffer.ByteBuf;
import com.arangodb.shaded.netty.buffer.Unpooled;
import com.arangodb.shaded.netty.channel.ChannelFutureListener;
import com.arangodb.shaded.netty.channel.ChannelHandlerContext;
import com.arangodb.shaded.netty.channel.ChannelInboundHandlerAdapter;
import com.arangodb.shaded.netty.util.CharsetUtil;

public class FlashPolicyHandler
extends ChannelInboundHandlerAdapter {
    private static final String XML = "<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"*\" /></cross-domain-policy>";
    private ParseState state = ParseState.MAGIC1;

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buffer = (ByteBuf)msg;
        int index = buffer.readerIndex();
        switch (this.state) {
            case MAGIC1: {
                if (!buffer.isReadable()) {
                    return;
                }
                short magic1 = buffer.getUnsignedByte(index++);
                this.state = ParseState.MAGIC2;
                if (magic1 != 60) {
                    ctx.fireChannelRead(buffer);
                    ctx.pipeline().remove(this);
                    return;
                }
            }
            case MAGIC2: {
                if (!buffer.isReadable()) {
                    return;
                }
                short magic2 = buffer.getUnsignedByte(index);
                if (magic2 != 112) {
                    ctx.fireChannelRead(buffer);
                    ctx.pipeline().remove(this);
                    break;
                }
                ctx.writeAndFlush(Unpooled.copiedBuffer(XML, CharsetUtil.UTF_8)).addListener(ChannelFutureListener.CLOSE);
            }
        }
    }

    static enum ParseState {
        MAGIC1,
        MAGIC2;

    }
}

