/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.impl;

import com.arangodb.shaded.netty.channel.EventLoop;
import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Closeable;
import com.arangodb.shaded.vertx.core.Context;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.Promise;
import com.arangodb.shaded.vertx.core.impl.CloseFuture;
import com.arangodb.shaded.vertx.core.impl.ContextBase;
import com.arangodb.shaded.vertx.core.impl.Deployment;
import com.arangodb.shaded.vertx.core.impl.TaskQueue;
import com.arangodb.shaded.vertx.core.impl.VertxImpl;
import com.arangodb.shaded.vertx.core.impl.VertxInternal;
import com.arangodb.shaded.vertx.core.impl.VertxThread;
import com.arangodb.shaded.vertx.core.impl.WorkerPool;
import com.arangodb.shaded.vertx.core.impl.future.FailedFuture;
import com.arangodb.shaded.vertx.core.impl.future.PromiseImpl;
import com.arangodb.shaded.vertx.core.impl.future.PromiseInternal;
import com.arangodb.shaded.vertx.core.impl.future.SucceededFuture;
import com.arangodb.shaded.vertx.core.spi.tracing.VertxTracer;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public interface ContextInternal
extends Context {
    public static ContextInternal current() {
        Thread thread = Thread.currentThread();
        if (thread instanceof VertxThread) {
            return ((VertxThread)thread).context();
        }
        VertxImpl.ContextDispatch current = VertxImpl.nonVertxContextDispatch.get();
        if (current != null) {
            return current.context;
        }
        return null;
    }

    @Override
    default public void runOnContext(Handler<Void> action) {
        this.executor().execute(() -> this.dispatch(action));
    }

    public Executor executor();

    public EventLoop nettyEventLoop();

    default public <T> PromiseInternal<T> promise() {
        return new PromiseImpl(this);
    }

    default public <T> PromiseInternal<T> promise(Handler<AsyncResult<T>> handler) {
        PromiseInternal<T> promise;
        if (handler instanceof PromiseInternal && (promise = (PromiseInternal<T>)handler).context() != null) {
            return promise;
        }
        promise = this.promise();
        promise.future().onComplete(handler);
        return promise;
    }

    default public <T> Future<T> succeededFuture() {
        return new SucceededFuture<Object>(this, null);
    }

    default public <T> Future<T> succeededFuture(T result) {
        return new SucceededFuture<T>(this, result);
    }

    default public <T> Future<T> failedFuture(Throwable failure) {
        return new FailedFuture(this, failure);
    }

    default public <T> Future<T> failedFuture(String message) {
        return new FailedFuture(this, message);
    }

    default public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, TaskQueue queue, Handler<AsyncResult<T>> resultHandler) {
        Future<T> fut = this.executeBlocking(blockingCodeHandler, queue);
        ContextBase.setResultHandler(this, fut, resultHandler);
    }

    public <T> Future<T> executeBlocking(Handler<Promise<T>> var1, TaskQueue var2);

    default public <T> void executeBlockingInternal(Handler<Promise<T>> action, Handler<AsyncResult<T>> resultHandler) {
        Future<T> fut = this.executeBlockingInternal(action);
        ContextBase.setResultHandler(this, fut, resultHandler);
    }

    default public <T> void executeBlockingInternal(Handler<Promise<T>> action, boolean ordered, Handler<AsyncResult<T>> resultHandler) {
        Future<T> fut = this.executeBlockingInternal(action, ordered);
        ContextBase.setResultHandler(this, fut, resultHandler);
    }

    @Override
    default public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) {
        Future<T> fut = this.executeBlocking(blockingCodeHandler, ordered);
        ContextBase.setResultHandler(this, fut, resultHandler);
    }

    public <T> Future<T> executeBlockingInternal(Handler<Promise<T>> var1);

    public <T> Future<T> executeBlockingInternal(Handler<Promise<T>> var1, boolean var2);

    public Deployment getDeployment();

    @Override
    public VertxInternal owner();

    public boolean inThread();

    public <T> void emit(T var1, Handler<T> var2);

    default public void emit(Handler<Void> task) {
        this.emit(null, task);
    }

    default public void execute(Handler<Void> task) {
        this.execute(null, task);
    }

    public void execute(Runnable var1);

    public <T> void execute(T var1, Handler<T> var2);

    default public boolean isRunningOnContext() {
        return ContextInternal.current() == this && this.inThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void dispatch(Runnable handler) {
        ContextInternal prev = this.beginDispatch();
        try {
            handler.run();
        }
        catch (Throwable t) {
            this.reportException(t);
        }
        finally {
            this.endDispatch(prev);
        }
    }

    default public void dispatch(Handler<Void> handler) {
        this.dispatch(null, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <E> void dispatch(E event, Handler<E> handler) {
        ContextInternal prev = this.beginDispatch();
        try {
            handler.handle(event);
        }
        catch (Throwable t) {
            this.reportException(t);
        }
        finally {
            this.endDispatch(prev);
        }
    }

    default public ContextInternal beginDispatch() {
        VertxImpl vertx = (VertxImpl)this.owner();
        return vertx.beginDispatch(this);
    }

    default public void endDispatch(ContextInternal previous) {
        VertxImpl vertx = (VertxImpl)this.owner();
        vertx.endDispatch(previous);
    }

    public void reportException(Throwable var1);

    public ConcurrentMap<Object, Object> contextData();

    @Override
    default public <T> T get(Object key) {
        return (T)this.contextData().get(key);
    }

    @Override
    default public void put(Object key, Object value) {
        this.contextData().put(key, value);
    }

    @Override
    default public boolean remove(Object key) {
        return this.contextData().remove(key) != null;
    }

    public ConcurrentMap<Object, Object> localContextData();

    @Override
    default public <T> T getLocal(Object key) {
        return (T)this.localContextData().get(key);
    }

    @Override
    default public void putLocal(Object key, Object value) {
        this.localContextData().put(key, value);
    }

    @Override
    default public boolean removeLocal(Object key) {
        return this.localContextData().remove(key) != null;
    }

    public ClassLoader classLoader();

    public WorkerPool workerPool();

    public VertxTracer tracer();

    public ContextInternal duplicate();

    default public long setPeriodic(long delay, Handler<Long> handler) {
        VertxImpl owner = (VertxImpl)this.owner();
        return owner.scheduleTimeout(this, true, delay, TimeUnit.MILLISECONDS, false, handler);
    }

    default public long setTimer(long delay, Handler<Long> handler) {
        VertxImpl owner = (VertxImpl)this.owner();
        return owner.scheduleTimeout(this, false, delay, TimeUnit.MILLISECONDS, false, handler);
    }

    default public boolean isDeployment() {
        return this.getDeployment() != null;
    }

    @Override
    default public String deploymentID() {
        Deployment deployment = this.getDeployment();
        return deployment != null ? deployment.deploymentID() : null;
    }

    @Override
    default public int getInstanceCount() {
        Deployment deployment = this.getDeployment();
        if (deployment == null) {
            return 0;
        }
        if (deployment.deploymentOptions() == null) {
            return 1;
        }
        return deployment.deploymentOptions().getInstances();
    }

    public CloseFuture closeFuture();

    default public void addCloseHook(Closeable hook) {
        this.closeFuture().add(hook);
    }

    default public void removeCloseHook(Closeable hook) {
        this.closeFuture().remove(hook);
    }

    default public ContextInternal unwrap() {
        return this;
    }

    default public boolean isDuplicate() {
        return false;
    }
}

