/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.impl;

import com.arangodb.shaded.vertx.core.Promise;
import com.arangodb.shaded.vertx.core.Verticle;
import com.arangodb.shaded.vertx.core.impl.verticle.CompilingClassLoader;
import com.arangodb.shaded.vertx.core.spi.VerticleFactory;
import java.util.concurrent.Callable;

public class JavaVerticleFactory
implements VerticleFactory {
    @Override
    public String prefix() {
        return "java";
    }

    @Override
    public void createVerticle(String verticleName, ClassLoader classLoader, Promise<Callable<Verticle>> promise) {
        Class<?> clazz;
        verticleName = VerticleFactory.removePrefix(verticleName);
        try {
            if (verticleName.endsWith(".java")) {
                CompilingClassLoader compilingLoader = new CompilingClassLoader(classLoader, verticleName);
                String className = compilingLoader.resolveMainClassName();
                clazz = compilingLoader.loadClass(className);
            } else {
                clazz = classLoader.loadClass(verticleName);
            }
        }
        catch (ClassNotFoundException e) {
            promise.fail(e);
            return;
        }
        promise.complete(clazz::newInstance);
    }
}

