/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.impl;

import com.arangodb.shaded.vertx.core.DeploymentOptions;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.ServiceHelper;
import com.arangodb.shaded.vertx.core.Verticle;
import com.arangodb.shaded.vertx.core.impl.ClassLoaderHolder;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import com.arangodb.shaded.vertx.core.impl.Deployment;
import com.arangodb.shaded.vertx.core.impl.DeploymentManager;
import com.arangodb.shaded.vertx.core.impl.JavaVerticleFactory;
import com.arangodb.shaded.vertx.core.impl.LoaderManager;
import com.arangodb.shaded.vertx.core.impl.VertxInternal;
import com.arangodb.shaded.vertx.core.impl.future.PromiseInternal;
import com.arangodb.shaded.vertx.core.spi.VerticleFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public class VerticleManager {
    private final VertxInternal vertx;
    private final DeploymentManager deploymentManager;
    private final LoaderManager loaderManager = new LoaderManager();
    private final Map<String, List<VerticleFactory>> verticleFactories = new ConcurrentHashMap<String, List<VerticleFactory>>();
    private final List<VerticleFactory> defaultFactories = new ArrayList<VerticleFactory>();

    public VerticleManager(VertxInternal vertx, DeploymentManager deploymentManager) {
        this.vertx = vertx;
        this.deploymentManager = deploymentManager;
        this.loadVerticleFactories();
    }

    private void loadVerticleFactories() {
        Collection<VerticleFactory> factories = ServiceHelper.loadFactories(VerticleFactory.class);
        factories.forEach(this::registerVerticleFactory);
        JavaVerticleFactory defaultFactory = new JavaVerticleFactory();
        defaultFactory.init(this.vertx);
        this.defaultFactories.add(defaultFactory);
    }

    public void registerVerticleFactory(VerticleFactory factory) {
        String prefix = factory.prefix();
        if (prefix == null) {
            throw new IllegalArgumentException("factory.prefix() cannot be null");
        }
        List<VerticleFactory> facts = this.verticleFactories.get(prefix);
        if (facts == null) {
            facts = new ArrayList<VerticleFactory>();
            this.verticleFactories.put(prefix, facts);
        }
        if (facts.contains(factory)) {
            throw new IllegalArgumentException("Factory already registered");
        }
        facts.add(factory);
        facts.sort((fact1, fact2) -> fact1.order() - fact2.order());
        factory.init(this.vertx);
    }

    public void unregisterVerticleFactory(VerticleFactory factory) {
        String prefix = factory.prefix();
        if (prefix == null) {
            throw new IllegalArgumentException("factory.prefix() cannot be null");
        }
        List<VerticleFactory> facts = this.verticleFactories.get(prefix);
        boolean removed = false;
        if (facts != null) {
            if (facts.remove(factory)) {
                removed = true;
            }
            if (facts.isEmpty()) {
                this.verticleFactories.remove(prefix);
            }
        }
        if (!removed) {
            throw new IllegalArgumentException("factory isn't registered");
        }
    }

    public Set<VerticleFactory> verticleFactories() {
        HashSet<VerticleFactory> facts = new HashSet<VerticleFactory>();
        for (List<VerticleFactory> list : this.verticleFactories.values()) {
            facts.addAll(list);
        }
        return facts;
    }

    private List<VerticleFactory> resolveFactories(String identifier) {
        List<VerticleFactory> factoryList = null;
        int pos = identifier.indexOf(58);
        String lookup = null;
        if (pos != -1) {
            lookup = identifier.substring(0, pos);
        } else {
            pos = identifier.lastIndexOf(46);
            if (pos != -1) {
                lookup = VerticleManager.getSuffix(pos, identifier);
            } else {
                factoryList = this.defaultFactories;
            }
        }
        if (factoryList == null && (factoryList = this.verticleFactories.get(lookup)) == null) {
            factoryList = this.defaultFactories;
        }
        return factoryList;
    }

    private static String getSuffix(int pos, String str) {
        if (pos + 1 >= str.length()) {
            throw new IllegalArgumentException("Invalid name: " + str);
        }
        return str.substring(pos + 1);
    }

    public Future<Deployment> deployVerticle(String identifier, DeploymentOptions options) {
        ClassLoaderHolder holder;
        ContextInternal callingContext = this.vertx.getOrCreateContext();
        ClassLoader loader = options.getClassLoader();
        if (loader == null) {
            holder = this.loaderManager.getClassLoader(options);
            loader = holder != null ? holder.loader : VerticleManager.getCurrentClassLoader();
        } else {
            holder = null;
        }
        Future<Deployment> deployment = this.doDeployVerticle(identifier, options, callingContext, callingContext, loader);
        if (holder != null) {
            deployment.onComplete(ar -> {
                if (!ar.succeeded()) {
                    throw new UnsupportedOperationException();
                }
                Deployment result = (Deployment)ar.result();
                result.undeployHandler(v -> this.loaderManager.release(holder));
            });
        }
        return deployment;
    }

    private Future<Deployment> doDeployVerticle(String identifier, DeploymentOptions options, ContextInternal parentContext, ContextInternal callingContext, ClassLoader cl) {
        List<VerticleFactory> verticleFactories = this.resolveFactories(identifier);
        Iterator<VerticleFactory> iter = verticleFactories.iterator();
        return this.doDeployVerticle(iter, null, identifier, options, parentContext, callingContext, cl);
    }

    private Future<Deployment> doDeployVerticle(Iterator<VerticleFactory> iter, Throwable prevErr, String identifier, DeploymentOptions options, ContextInternal parentContext, ContextInternal callingContext, ClassLoader cl) {
        if (iter.hasNext()) {
            VerticleFactory verticleFactory = iter.next();
            return this.doDeployVerticle(verticleFactory, identifier, options, parentContext, callingContext, cl).recover(err -> this.doDeployVerticle(iter, (Throwable)err, identifier, options, parentContext, callingContext, cl));
        }
        if (prevErr != null) {
            return callingContext.failedFuture(prevErr);
        }
        throw new UnsupportedOperationException();
    }

    private Future<Deployment> doDeployVerticle(VerticleFactory verticleFactory, String identifier, DeploymentOptions options, ContextInternal parentContext, ContextInternal callingContext, ClassLoader cl) {
        PromiseInternal<Callable<Verticle>> p = callingContext.promise();
        try {
            verticleFactory.createVerticle(identifier, cl, p);
        }
        catch (Exception e) {
            return Future.failedFuture(e);
        }
        return p.future().compose(callable -> this.deploymentManager.doDeploy(options, v -> identifier, parentContext, callingContext, cl, (Callable<Verticle>)callable));
    }

    static ClassLoader getCurrentClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = VerticleManager.class.getClassLoader();
        }
        return cl;
    }
}

