/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.impl;

import com.arangodb.shaded.vertx.core.Context;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.impl.CloseFuture;
import com.arangodb.shaded.vertx.core.impl.ContextBase;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import com.arangodb.shaded.vertx.core.impl.Deployment;
import com.arangodb.shaded.vertx.core.impl.TaskQueue;
import com.arangodb.shaded.vertx.core.impl.VertxInternal;
import com.arangodb.shaded.vertx.core.impl.WorkerPool;
import com.arangodb.shaded.vertx.core.spi.metrics.PoolMetrics;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public class WorkerContext
extends ContextBase {
    private Executor executor;

    WorkerContext(VertxInternal vertx, WorkerPool internalBlockingPool, WorkerPool workerPool, Deployment deployment, CloseFuture closeFuture, ClassLoader tccl) {
        super(vertx, vertx.getEventLoopGroup().next(), internalBlockingPool, workerPool, deployment, closeFuture, tccl);
    }

    @Override
    protected void runOnContext(ContextInternal ctx, Handler<Void> action) {
        try {
            this.run(ctx, null, action);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    protected <T> void execute(ContextInternal ctx, T argument, Handler<T> task) {
        this.execute(this.orderedTasks, argument, task);
    }

    @Override
    protected <T> void emit(ContextInternal ctx, T argument, Handler<T> task) {
        this.execute(this.orderedTasks, argument, (T arg) -> ctx.dispatch(arg, task));
    }

    @Override
    protected <T> void execute(ContextInternal ctx, Runnable task) {
        this.execute(this, task, Runnable::run);
    }

    @Override
    public boolean isEventLoopContext() {
        return false;
    }

    @Override
    public boolean isWorkerContext() {
        return true;
    }

    @Override
    public Executor executor() {
        if (this.executor == null) {
            this.executor = command -> {
                PoolMetrics metrics = this.workerPool.metrics();
                Object queueMetric = metrics != null ? metrics.submitted() : null;
                this.orderedTasks.execute(() -> {
                    Object execMetric = null;
                    if (metrics != null) {
                        execMetric = metrics.begin(queueMetric);
                    }
                    try {
                        command.run();
                    }
                    finally {
                        if (metrics != null) {
                            metrics.end(execMetric, true);
                        }
                    }
                }, this.workerPool.executor());
            };
        }
        return this.executor;
    }

    private <T> void run(ContextInternal ctx, T value, Handler<T> task) {
        Objects.requireNonNull(task, "Task handler must not be null");
        this.executor().execute(() -> ctx.dispatch(value, task));
    }

    private <T> void execute(TaskQueue queue, T argument, Handler<T> task) {
        if (Context.isOnWorkerThread()) {
            task.handle(argument);
        } else {
            PoolMetrics metrics = this.workerPool.metrics();
            Object queueMetric = metrics != null ? metrics.submitted() : null;
            queue.execute(() -> {
                Object execMetric = null;
                if (metrics != null) {
                    execMetric = metrics.begin(queueMetric);
                }
                try {
                    task.handle(argument);
                }
                finally {
                    if (metrics != null) {
                        metrics.end(execMetric, true);
                    }
                }
            }, this.workerPool.executor());
        }
    }

    @Override
    public boolean inThread() {
        return Context.isOnWorkerThread();
    }
}

