/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.impl.future;

import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import com.arangodb.shaded.vertx.core.impl.future.FutureInternal;
import com.arangodb.shaded.vertx.core.impl.future.Listener;
import com.arangodb.shaded.vertx.core.impl.future.Operation;
import java.util.function.Function;

class Transformation<T, U>
extends Operation<U>
implements Listener<T> {
    private final Future<T> future;
    private final Function<AsyncResult<T>, Future<U>> mapper;

    Transformation(ContextInternal context, Future<T> future, Function<AsyncResult<T>, Future<U>> mapper) {
        super(context);
        this.future = future;
        this.mapper = mapper;
    }

    @Override
    public void onSuccess(T value) {
        FutureInternal future;
        try {
            future = (FutureInternal)this.mapper.apply(this.future);
        }
        catch (Throwable e) {
            this.tryFail(e);
            return;
        }
        future.addListener(this.newListener());
    }

    @Override
    public void onFailure(Throwable failure) {
        FutureInternal future;
        try {
            future = (FutureInternal)this.mapper.apply(this.future);
        }
        catch (Throwable e) {
            this.tryFail(e);
            return;
        }
        future.addListener(this.newListener());
    }

    private Listener<U> newListener() {
        return new Listener<U>(){

            @Override
            public void onSuccess(U value) {
                Transformation.this.tryComplete(value);
            }

            @Override
            public void onFailure(Throwable failure) {
                Transformation.this.tryFail(failure);
            }
        };
    }
}

