/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.impl.transports;

import com.arangodb.shaded.netty.bootstrap.Bootstrap;
import com.arangodb.shaded.netty.bootstrap.ServerBootstrap;
import com.arangodb.shaded.netty.channel.Channel;
import com.arangodb.shaded.netty.channel.ChannelFactory;
import com.arangodb.shaded.netty.channel.EventLoopGroup;
import com.arangodb.shaded.netty.channel.ServerChannel;
import com.arangodb.shaded.netty.channel.epoll.Epoll;
import com.arangodb.shaded.netty.channel.epoll.EpollChannelOption;
import com.arangodb.shaded.netty.channel.epoll.EpollDatagramChannel;
import com.arangodb.shaded.netty.channel.epoll.EpollDomainSocketChannel;
import com.arangodb.shaded.netty.channel.epoll.EpollEventLoopGroup;
import com.arangodb.shaded.netty.channel.epoll.EpollServerDomainSocketChannel;
import com.arangodb.shaded.netty.channel.epoll.EpollServerSocketChannel;
import com.arangodb.shaded.netty.channel.epoll.EpollSocketChannel;
import com.arangodb.shaded.netty.channel.socket.DatagramChannel;
import com.arangodb.shaded.netty.channel.socket.InternetProtocolFamily;
import com.arangodb.shaded.netty.channel.unix.DomainSocketAddress;
import com.arangodb.shaded.vertx.core.datagram.DatagramSocketOptions;
import com.arangodb.shaded.vertx.core.net.ClientOptionsBase;
import com.arangodb.shaded.vertx.core.net.NetServerOptions;
import com.arangodb.shaded.vertx.core.net.impl.SocketAddressImpl;
import com.arangodb.shaded.vertx.core.spi.transport.Transport;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;

public class EpollTransport
implements Transport {
    private static volatile int pendingFastOpenRequestsThreshold = 256;

    public static int getPendingFastOpenRequestsThreshold() {
        return pendingFastOpenRequestsThreshold;
    }

    public static void setPendingFastOpenRequestsThreshold(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Invalid " + value);
        }
        pendingFastOpenRequestsThreshold = value;
    }

    @Override
    public boolean supportsDomainSockets() {
        return true;
    }

    @Override
    public SocketAddress convert(com.arangodb.shaded.vertx.core.net.SocketAddress address) {
        if (address.isDomainSocket()) {
            return new DomainSocketAddress(address.path());
        }
        return Transport.super.convert(address);
    }

    @Override
    public com.arangodb.shaded.vertx.core.net.SocketAddress convert(SocketAddress address) {
        if (address instanceof DomainSocketAddress) {
            return new SocketAddressImpl(((DomainSocketAddress)address).path());
        }
        return Transport.super.convert(address);
    }

    @Override
    public boolean isAvailable() {
        return Epoll.isAvailable();
    }

    @Override
    public Throwable unavailabilityCause() {
        return Epoll.unavailabilityCause();
    }

    @Override
    public EventLoopGroup eventLoopGroup(int type, int nThreads, ThreadFactory threadFactory, int ioRatio) {
        EpollEventLoopGroup eventLoopGroup = new EpollEventLoopGroup(nThreads, threadFactory);
        eventLoopGroup.setIoRatio(ioRatio);
        return eventLoopGroup;
    }

    @Override
    public DatagramChannel datagramChannel() {
        return new EpollDatagramChannel();
    }

    @Override
    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        return new EpollDatagramChannel();
    }

    @Override
    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (domainSocket) {
            return EpollDomainSocketChannel::new;
        }
        return EpollSocketChannel::new;
    }

    @Override
    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (domainSocket) {
            return EpollServerDomainSocketChannel::new;
        }
        return EpollServerSocketChannel::new;
    }

    @Override
    public void configure(DatagramChannel channel, DatagramSocketOptions options) {
        channel.config().setOption(EpollChannelOption.SO_REUSEPORT, options.isReusePort());
        Transport.super.configure(channel, options);
    }

    @Override
    public void configure(NetServerOptions options, boolean domainSocket, ServerBootstrap bootstrap) {
        if (!domainSocket) {
            bootstrap.option(EpollChannelOption.SO_REUSEPORT, options.isReusePort());
            if (options.isTcpFastOpen()) {
                bootstrap.option(EpollChannelOption.TCP_FASTOPEN, options.isTcpFastOpen() ? pendingFastOpenRequestsThreshold : 0);
            }
            bootstrap.childOption(EpollChannelOption.TCP_QUICKACK, options.isTcpQuickAck());
            bootstrap.childOption(EpollChannelOption.TCP_CORK, options.isTcpCork());
        }
        Transport.super.configure(options, domainSocket, bootstrap);
    }

    @Override
    public void configure(ClientOptionsBase options, boolean domainSocket, Bootstrap bootstrap) {
        if (!domainSocket) {
            if (options.isTcpFastOpen()) {
                bootstrap.option(EpollChannelOption.TCP_FASTOPEN_CONNECT, options.isTcpFastOpen());
            }
            bootstrap.option(EpollChannelOption.TCP_USER_TIMEOUT, options.getTcpUserTimeout());
            bootstrap.option(EpollChannelOption.TCP_QUICKACK, options.isTcpQuickAck());
            bootstrap.option(EpollChannelOption.TCP_CORK, options.isTcpCork());
        }
        Transport.super.configure(options, domainSocket, bootstrap);
    }
}

