/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.impl.transports;

import com.arangodb.shaded.netty.bootstrap.ServerBootstrap;
import com.arangodb.shaded.netty.channel.Channel;
import com.arangodb.shaded.netty.channel.ChannelFactory;
import com.arangodb.shaded.netty.channel.EventLoopGroup;
import com.arangodb.shaded.netty.channel.ServerChannel;
import com.arangodb.shaded.netty.channel.kqueue.KQueue;
import com.arangodb.shaded.netty.channel.kqueue.KQueueChannelOption;
import com.arangodb.shaded.netty.channel.kqueue.KQueueDatagramChannel;
import com.arangodb.shaded.netty.channel.kqueue.KQueueDomainSocketChannel;
import com.arangodb.shaded.netty.channel.kqueue.KQueueEventLoopGroup;
import com.arangodb.shaded.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import com.arangodb.shaded.netty.channel.kqueue.KQueueServerSocketChannel;
import com.arangodb.shaded.netty.channel.kqueue.KQueueSocketChannel;
import com.arangodb.shaded.netty.channel.socket.DatagramChannel;
import com.arangodb.shaded.netty.channel.socket.InternetProtocolFamily;
import com.arangodb.shaded.netty.channel.unix.DomainSocketAddress;
import com.arangodb.shaded.vertx.core.datagram.DatagramSocketOptions;
import com.arangodb.shaded.vertx.core.net.NetServerOptions;
import com.arangodb.shaded.vertx.core.net.impl.SocketAddressImpl;
import com.arangodb.shaded.vertx.core.spi.transport.Transport;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;

public class KQueueTransport
implements Transport {
    @Override
    public boolean supportsDomainSockets() {
        return true;
    }

    @Override
    public SocketAddress convert(com.arangodb.shaded.vertx.core.net.SocketAddress address) {
        if (address.isDomainSocket()) {
            return new DomainSocketAddress(address.path());
        }
        return Transport.super.convert(address);
    }

    @Override
    public com.arangodb.shaded.vertx.core.net.SocketAddress convert(SocketAddress address) {
        if (address instanceof DomainSocketAddress) {
            String path = ((DomainSocketAddress)address).path();
            if (path.isEmpty()) {
                return null;
            }
            return new SocketAddressImpl(path);
        }
        return Transport.super.convert(address);
    }

    @Override
    public boolean isAvailable() {
        return KQueue.isAvailable();
    }

    @Override
    public Throwable unavailabilityCause() {
        return KQueue.unavailabilityCause();
    }

    @Override
    public EventLoopGroup eventLoopGroup(int type, int nThreads, ThreadFactory threadFactory, int ioRatio) {
        KQueueEventLoopGroup eventLoopGroup = new KQueueEventLoopGroup(nThreads, threadFactory);
        eventLoopGroup.setIoRatio(ioRatio);
        return eventLoopGroup;
    }

    @Override
    public DatagramChannel datagramChannel() {
        return new KQueueDatagramChannel();
    }

    @Override
    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        return new KQueueDatagramChannel();
    }

    @Override
    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (domainSocket) {
            return KQueueDomainSocketChannel::new;
        }
        return KQueueSocketChannel::new;
    }

    @Override
    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (domainSocket) {
            return KQueueServerDomainSocketChannel::new;
        }
        return KQueueServerSocketChannel::new;
    }

    @Override
    public void configure(NetServerOptions options, boolean domainSocket, ServerBootstrap bootstrap) {
        if (!domainSocket) {
            bootstrap.option(KQueueChannelOption.SO_REUSEPORT, options.isReusePort());
        }
        Transport.super.configure(options, domainSocket, bootstrap);
    }

    @Override
    public void configure(DatagramChannel channel, DatagramSocketOptions options) {
        channel.config().setOption(KQueueChannelOption.SO_REUSEPORT, options.isReusePort());
        Transport.super.configure(channel, options);
    }
}

