/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.json.jackson;

import com.arangodb.shaded.fasterxml.jackson.core.JsonParser;
import com.arangodb.shaded.fasterxml.jackson.core.JsonProcessingException;
import com.arangodb.shaded.fasterxml.jackson.databind.DeserializationContext;
import com.arangodb.shaded.fasterxml.jackson.databind.JsonDeserializer;
import com.arangodb.shaded.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.arangodb.shaded.vertx.core.buffer.Buffer;
import com.arangodb.shaded.vertx.core.json.impl.JsonUtil;
import java.io.IOException;
import java.time.Instant;

class BufferDeserializer
extends JsonDeserializer<Buffer> {
    BufferDeserializer() {
    }

    @Override
    public Buffer deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String text = p.getText();
        try {
            return Buffer.buffer(JsonUtil.BASE64_DECODER.decode(text));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(p, "Expected a base64 encoded byte array", (Object)text, Instant.class);
        }
    }
}

