/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.json.pointer.impl;

import com.arangodb.shaded.vertx.core.json.JsonArray;
import com.arangodb.shaded.vertx.core.json.JsonObject;
import com.arangodb.shaded.vertx.core.json.pointer.JsonPointerIterator;
import java.util.List;
import java.util.Map;

public class JsonPointerIteratorImpl
implements JsonPointerIterator {
    @Override
    public boolean isObject(Object value) {
        return value instanceof JsonObject;
    }

    @Override
    public boolean isArray(Object value) {
        return value instanceof JsonArray;
    }

    @Override
    public boolean isNull(Object value) {
        return value == null;
    }

    @Override
    public boolean objectContainsKey(Object value, String key) {
        return this.isObject(value) && ((JsonObject)value).containsKey(key);
    }

    @Override
    public Object getObjectParameter(Object value, String key, boolean createOnMissing) {
        if (this.isObject(value)) {
            if (!this.objectContainsKey(value, key)) {
                if (createOnMissing) {
                    this.writeObjectParameter(value, key, new JsonObject());
                } else {
                    return null;
                }
            }
            return this.jsonifyValue(((JsonObject)value).getValue(key));
        }
        return null;
    }

    @Override
    public Object getArrayElement(Object value, int i) {
        if (this.isArray(value)) {
            try {
                return this.jsonifyValue(((JsonArray)value).getValue(i));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean writeObjectParameter(Object value, String key, Object el) {
        if (this.isObject(value)) {
            ((JsonObject)value).put(key, el);
            return true;
        }
        return false;
    }

    @Override
    public boolean writeArrayElement(Object value, int i, Object el) {
        if (this.isArray(value)) {
            try {
                ((JsonArray)value).getList().add(i, el);
                return true;
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean appendArrayElement(Object value, Object el) {
        if (this.isArray(value)) {
            ((JsonArray)value).add(el);
            return true;
        }
        return false;
    }

    private Object jsonifyValue(Object v) {
        if (v instanceof Map) {
            return new JsonObject((Map)v);
        }
        if (v instanceof List) {
            return new JsonArray((List)v);
        }
        return v;
    }
}

