/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.net;

import com.arangodb.shaded.vertx.core.Vertx;
import com.arangodb.shaded.vertx.core.net.KeyManagerFactoryOptions;
import com.arangodb.shaded.vertx.core.net.impl.KeyStoreHelper;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;

public interface KeyCertOptions {
    public KeyCertOptions copy();

    public KeyManagerFactory getKeyManagerFactory(Vertx var1) throws Exception;

    @Deprecated
    public Function<String, X509KeyManager> keyManagerMapper(Vertx var1) throws Exception;

    default public Function<String, KeyManagerFactory> keyManagerFactoryMapper(Vertx vertx) throws Exception {
        Function<String, X509KeyManager> mapper = this.keyManagerMapper(vertx);
        return name -> {
            X509KeyManager mgr = (X509KeyManager)mapper.apply((String)name);
            if (mgr != null) {
                try {
                    return KeyStoreHelper.toKeyManagerFactory(mgr);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        };
    }

    public static KeyCertOptions wrap(X509KeyManager keyManager) {
        return new KeyManagerFactoryOptions(keyManager);
    }

    public static KeyCertOptions wrap(KeyManagerFactory keyManagerFactory) {
        return new KeyManagerFactoryOptions(keyManagerFactory);
    }
}

