/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.net;

import com.arangodb.shaded.vertx.core.buffer.Buffer;
import com.arangodb.shaded.vertx.core.json.JsonObject;
import com.arangodb.shaded.vertx.core.json.impl.JsonUtil;
import com.arangodb.shaded.vertx.core.net.PfxOptions;
import java.util.Base64;
import java.util.Map;

public class PfxOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, PfxOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "alias": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAlias((String)member.getValue());
                    break;
                }
                case "aliasPassword": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAliasPassword((String)member.getValue());
                    break;
                }
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPassword((String)member.getValue());
                    break;
                }
                case "path": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPath((String)member.getValue());
                    break;
                }
                case "value": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setValue(Buffer.buffer(BASE64_DECODER.decode((String)member.getValue())));
                }
            }
        }
    }

    static void toJson(PfxOptions obj, JsonObject json) {
        PfxOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(PfxOptions obj, Map<String, Object> json) {
        if (obj.getAlias() != null) {
            json.put("alias", obj.getAlias());
        }
        if (obj.getAliasPassword() != null) {
            json.put("aliasPassword", obj.getAliasPassword());
        }
        if (obj.getPassword() != null) {
            json.put("password", obj.getPassword());
        }
        if (obj.getPath() != null) {
            json.put("path", obj.getPath());
        }
        if (obj.getValue() != null) {
            json.put("value", BASE64_ENCODER.encodeToString(obj.getValue().getBytes()));
        }
    }
}

