/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.net.impl;

import com.arangodb.shaded.netty.buffer.ByteBuf;
import com.arangodb.shaded.netty.buffer.Unpooled;
import com.arangodb.shaded.netty.channel.ChannelFuture;
import com.arangodb.shaded.netty.channel.ChannelHandler;
import com.arangodb.shaded.netty.channel.ChannelHandlerContext;
import com.arangodb.shaded.netty.channel.ChannelPromise;
import com.arangodb.shaded.netty.util.CharsetUtil;
import com.arangodb.shaded.netty.util.ReferenceCounted;
import com.arangodb.shaded.netty.util.concurrent.GenericFutureListener;
import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.buffer.Buffer;
import com.arangodb.shaded.vertx.core.eventbus.Message;
import com.arangodb.shaded.vertx.core.eventbus.MessageConsumer;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import com.arangodb.shaded.vertx.core.impl.future.PromiseInternal;
import com.arangodb.shaded.vertx.core.impl.logging.Logger;
import com.arangodb.shaded.vertx.core.impl.logging.LoggerFactory;
import com.arangodb.shaded.vertx.core.net.NetSocket;
import com.arangodb.shaded.vertx.core.net.SocketAddress;
import com.arangodb.shaded.vertx.core.net.impl.ConnectionBase;
import com.arangodb.shaded.vertx.core.net.impl.NetSocketInternal;
import com.arangodb.shaded.vertx.core.net.impl.SslChannelProvider;
import com.arangodb.shaded.vertx.core.net.impl.SslHandshakeCompletionHandler;
import com.arangodb.shaded.vertx.core.net.impl.VertxHandler;
import com.arangodb.shaded.vertx.core.spi.metrics.TCPMetrics;
import com.arangodb.shaded.vertx.core.streams.impl.InboundBuffer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.UUID;

public class NetSocketImpl
extends ConnectionBase
implements NetSocketInternal {
    private static final Logger log = LoggerFactory.getLogger(NetSocketImpl.class);
    private final String writeHandlerID;
    private final SslChannelProvider sslChannelProvider;
    private final SocketAddress remoteAddress;
    private final TCPMetrics metrics;
    private final InboundBuffer<Object> pending;
    private final String negotiatedApplicationLayerProtocol;
    private Handler<Void> endHandler;
    private Handler<Void> drainHandler;
    private MessageConsumer registration;
    private Handler<Buffer> handler;
    private Handler<Object> messageHandler;
    private Handler<Object> eventHandler;

    public NetSocketImpl(ContextInternal context, ChannelHandlerContext channel, SslChannelProvider sslChannelProvider, TCPMetrics metrics, boolean registerWriteHandler) {
        this(context, channel, null, sslChannelProvider, metrics, null, registerWriteHandler);
    }

    public NetSocketImpl(ContextInternal context, ChannelHandlerContext channel, SocketAddress remoteAddress, SslChannelProvider sslChannelProvider, TCPMetrics metrics, String negotiatedApplicationLayerProtocol, boolean registerWriteHandler) {
        super(context, channel);
        this.sslChannelProvider = sslChannelProvider;
        this.writeHandlerID = registerWriteHandler ? "__vertx.net." + UUID.randomUUID() : null;
        this.remoteAddress = remoteAddress;
        this.metrics = metrics;
        this.messageHandler = new DataMessageHandler();
        this.negotiatedApplicationLayerProtocol = negotiatedApplicationLayerProtocol;
        this.pending = new InboundBuffer(context);
        this.pending.drainHandler((Void v) -> this.doResume());
        this.pending.exceptionHandler(context::reportException);
        this.pending.handler((E msg) -> {
            if (msg == InboundBuffer.END_SENTINEL) {
                Handler<Void> handler = this.endHandler();
                if (handler != null) {
                    handler.handle(null);
                }
            } else {
                Handler<Buffer> handler = this.handler();
                if (handler != null) {
                    handler.handle((Buffer)msg);
                }
            }
        });
    }

    void registerEventBusHandler() {
        if (this.writeHandlerID != null) {
            Handler<Message> writeHandler = msg -> this.write((Buffer)msg.body());
            this.registration = this.vertx.eventBus().localConsumer(this.writeHandlerID).handler(writeHandler);
        }
    }

    void unregisterEventBusHandler() {
        if (this.registration != null) {
            MessageConsumer consumer = this.registration;
            this.registration = null;
            consumer.unregister();
        }
    }

    @Override
    public TCPMetrics metrics() {
        return this.metrics;
    }

    @Override
    public String writeHandlerID() {
        return this.writeHandlerID;
    }

    @Override
    public synchronized Future<Void> writeMessage(Object message) {
        PromiseInternal<Void> promise = this.context.promise();
        this.writeMessage(message, promise);
        return promise.future();
    }

    @Override
    public NetSocketInternal writeMessage(Object message, Handler<AsyncResult<Void>> handler) {
        this.writeToChannel(message, handler == null ? null : this.context.promise(handler));
        return this;
    }

    @Override
    public String applicationLayerProtocol() {
        return this.negotiatedApplicationLayerProtocol;
    }

    @Override
    public Future<Void> write(Buffer data) {
        return this.writeMessage(data.getByteBuf());
    }

    @Override
    public void write(String str, Handler<AsyncResult<Void>> handler) {
        this.write(Unpooled.copiedBuffer(str, CharsetUtil.UTF_8), handler);
    }

    @Override
    public Future<Void> write(String str) {
        return this.writeMessage(Unpooled.copiedBuffer(str, CharsetUtil.UTF_8));
    }

    @Override
    public Future<Void> write(String str, String enc) {
        return this.writeMessage(Unpooled.copiedBuffer(str, Charset.forName(enc)));
    }

    @Override
    public void write(String str, String enc, Handler<AsyncResult<Void>> handler) {
        Charset cs = enc != null ? Charset.forName(enc) : CharsetUtil.UTF_8;
        this.write(Unpooled.copiedBuffer(str, cs), handler);
    }

    @Override
    public void write(Buffer message, Handler<AsyncResult<Void>> handler) {
        this.write(message.getByteBuf(), handler);
    }

    @Override
    private void write(ByteBuf buff, Handler<AsyncResult<Void>> handler) {
        this.reportBytesWritten(buff.readableBytes());
        this.writeMessage(buff, handler);
    }

    private synchronized Handler<Buffer> handler() {
        return this.handler;
    }

    @Override
    public synchronized NetSocket handler(Handler<Buffer> dataHandler) {
        this.handler = dataHandler;
        return this;
    }

    private synchronized Handler<Object> messageHandler() {
        return this.messageHandler;
    }

    @Override
    public synchronized NetSocketInternal messageHandler(Handler<Object> handler) {
        this.messageHandler = handler == null ? new DataMessageHandler() : handler;
        return this;
    }

    @Override
    public synchronized NetSocketInternal eventHandler(Handler<Object> handler) {
        this.eventHandler = handler;
        return this;
    }

    @Override
    public synchronized NetSocket pause() {
        this.pending.pause();
        return this;
    }

    @Override
    public NetSocket fetch(long amount) {
        this.pending.fetch(amount);
        return this;
    }

    @Override
    public synchronized NetSocket resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    @Override
    public NetSocket setWriteQueueMaxSize(int maxSize) {
        this.doSetWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        return this.isNotWritable();
    }

    private synchronized Handler<Void> endHandler() {
        return this.endHandler;
    }

    @Override
    public synchronized NetSocket endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    @Override
    public synchronized NetSocket drainHandler(Handler<Void> drainHandler) {
        this.drainHandler = drainHandler;
        this.vertx.runOnContext(v -> this.callDrainHandler());
        return this;
    }

    @Override
    public Future<Void> sendFile(String filename, long offset, long length) {
        PromiseInternal<Void> promise = this.context.promise();
        this.sendFile(filename, offset, length, promise);
        return promise.future();
    }

    @Override
    public NetSocket sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        File f = this.vertx.resolveFile(filename);
        if (f.isDirectory()) {
            throw new IllegalArgumentException("filename must point to a file and not to a directory");
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(f, "r");
            ChannelFuture future = super.sendFile(raf, Math.min(offset, f.length()), Math.min(length, f.length() - offset));
            if (resultHandler != null) {
                future.addListener((GenericFutureListener<? extends com.arangodb.shaded.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<com.arangodb.shaded.netty.util.concurrent.Future>)fut -> {
                    Future res = future.isSuccess() ? Future.succeededFuture() : Future.failedFuture(future.cause());
                    this.vertx.runOnContext(v -> resultHandler.handle(res));
                }));
            }
        }
        catch (IOException e) {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (resultHandler != null) {
                this.vertx.runOnContext(v -> resultHandler.handle(Future.failedFuture(e)));
            }
            log.error("Failed to send file", e);
        }
        return this;
    }

    @Override
    public NetSocketImpl exceptionHandler(Handler<Throwable> handler) {
        return (NetSocketImpl)super.exceptionHandler(handler);
    }

    @Override
    public NetSocketImpl closeHandler(Handler<Void> handler) {
        return (NetSocketImpl)super.closeHandler(handler);
    }

    @Override
    public Future<Void> upgradeToSsl() {
        return this.upgradeToSsl((String)null);
    }

    @Override
    public Future<Void> upgradeToSsl(String serverName) {
        PromiseInternal promise = this.context.promise();
        if (this.chctx.pipeline().get("ssl") == null) {
            ChannelPromise flush = this.chctx.newPromise();
            this.flush(flush);
            flush.addListener((GenericFutureListener<? extends com.arangodb.shaded.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<com.arangodb.shaded.netty.util.concurrent.Future>)fut -> {
                if (fut.isSuccess()) {
                    ChannelPromise channelPromise = this.chctx.newPromise();
                    this.chctx.pipeline().addFirst("handshaker", (ChannelHandler)new SslHandshakeCompletionHandler(channelPromise));
                    channelPromise.addListener(promise);
                    ChannelHandler sslHandler = this.remoteAddress != null ? this.sslChannelProvider.createClientSslHandler(this.remoteAddress, serverName, false) : this.sslChannelProvider.createServerHandler();
                    this.chctx.pipeline().addFirst("ssl", sslHandler);
                } else {
                    promise.fail(fut.cause());
                }
            }));
        }
        return promise.future();
    }

    @Override
    public NetSocket upgradeToSsl(Handler<AsyncResult<Void>> handler) {
        return this.upgradeToSsl(null, handler);
    }

    @Override
    public NetSocket upgradeToSsl(String serverName, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.upgradeToSsl(serverName);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    protected void handleInterestedOpsChanged() {
        this.context.emit(null, v -> this.callDrainHandler());
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.close(handler);
    }

    @Override
    public Future<Void> end() {
        return this.close();
    }

    @Override
    protected void handleClosed() {
        this.context.emit(InboundBuffer.END_SENTINEL, this.pending::write);
        super.handleClosed();
    }

    @Override
    public void handleMessage(Object msg) {
        this.context.emit(msg, this.messageHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleEvent(Object evt) {
        Handler<Object> handler;
        NetSocketImpl netSocketImpl = this;
        synchronized (netSocketImpl) {
            handler = this.eventHandler;
        }
        if (handler != null) {
            this.context.emit(evt, handler);
        } else {
            super.handleEvent(evt);
        }
    }

    private synchronized void callDrainHandler() {
        if (this.drainHandler != null && !this.writeQueueFull()) {
            this.drainHandler.handle(null);
        }
    }

    private class DataMessageHandler
    implements Handler<Object> {
        private DataMessageHandler() {
        }

        @Override
        public void handle(Object msg) {
            if (msg instanceof ByteBuf) {
                msg = VertxHandler.safeBuffer((ByteBuf)msg);
                ByteBuf byteBuf = (ByteBuf)msg;
                Buffer buffer = Buffer.buffer(byteBuf);
                if (!NetSocketImpl.this.pending.write(buffer)) {
                    NetSocketImpl.this.doPause();
                }
            } else {
                this.handleInvalid(msg);
            }
        }

        private void handleInvalid(Object msg) {
            if (msg instanceof ReferenceCounted && !(msg instanceof ByteBuf)) {
                ReferenceCounted refCounter = (ReferenceCounted)msg;
                refCounter.release();
            }
        }
    }
}

