/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.net.impl;

import com.arangodb.shaded.netty.bootstrap.ServerBootstrap;
import com.arangodb.shaded.netty.buffer.PooledByteBufAllocator;
import com.arangodb.shaded.netty.channel.Channel;
import com.arangodb.shaded.netty.channel.ChannelFuture;
import com.arangodb.shaded.netty.channel.ChannelOption;
import com.arangodb.shaded.netty.channel.EventLoop;
import com.arangodb.shaded.netty.util.concurrent.GenericFutureListener;
import com.arangodb.shaded.vertx.core.Closeable;
import com.arangodb.shaded.vertx.core.Context;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.Promise;
import com.arangodb.shaded.vertx.core.buffer.impl.PartialPooledByteBufAllocator;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import com.arangodb.shaded.vertx.core.impl.VertxInternal;
import com.arangodb.shaded.vertx.core.impl.future.PromiseInternal;
import com.arangodb.shaded.vertx.core.impl.logging.Logger;
import com.arangodb.shaded.vertx.core.impl.logging.LoggerFactory;
import com.arangodb.shaded.vertx.core.net.NetServerOptions;
import com.arangodb.shaded.vertx.core.net.SSLOptions;
import com.arangodb.shaded.vertx.core.net.SocketAddress;
import com.arangodb.shaded.vertx.core.net.impl.AsyncResolveConnectHelper;
import com.arangodb.shaded.vertx.core.net.impl.NetServerImpl;
import com.arangodb.shaded.vertx.core.net.impl.SSLHelper;
import com.arangodb.shaded.vertx.core.net.impl.ServerChannelLoadBalancer;
import com.arangodb.shaded.vertx.core.net.impl.ServerID;
import com.arangodb.shaded.vertx.core.net.impl.SslChannelProvider;
import com.arangodb.shaded.vertx.core.net.impl.SslContextProvider;
import com.arangodb.shaded.vertx.core.spi.metrics.MetricsProvider;
import com.arangodb.shaded.vertx.core.spi.metrics.TCPMetrics;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

public abstract class TCPServerBase
implements Closeable,
MetricsProvider {
    private static final Logger log = LoggerFactory.getLogger(NetServerImpl.class);
    protected final Context creatingContext;
    protected final VertxInternal vertx;
    protected final NetServerOptions options;
    private EventLoop eventLoop;
    private BiConsumer<Channel, SslChannelProvider> childHandler;
    private Handler<Channel> worker;
    private volatile boolean listening;
    private ContextInternal listenContext;
    private TCPServerBase actualServer;
    private SSLHelper sslHelper;
    private AtomicReference<SslChannelProvider> sslChannelProvider;
    private ServerChannelLoadBalancer channelBalancer;
    private Future<Channel> bindFuture;
    private Set<TCPServerBase> servers;
    private TCPMetrics<?> metrics;
    private volatile int actualPort;

    public TCPServerBase(VertxInternal vertx, NetServerOptions options) {
        this.vertx = vertx;
        this.options = new NetServerOptions(options);
        this.creatingContext = vertx.getContext();
        this.sslChannelProvider = new AtomicReference();
    }

    public SslContextProvider sslContextProvider() {
        SslChannelProvider ref = this.sslChannelProvider.get();
        return ref != null ? ref.sslContextProvider() : null;
    }

    public int actualPort() {
        TCPServerBase server = this.actualServer;
        return server != null ? server.actualPort : this.actualPort;
    }

    protected abstract BiConsumer<Channel, SslChannelProvider> childHandler(ContextInternal var1, SocketAddress var2);

    protected SSLHelper createSSLHelper() {
        return new SSLHelper(this.options, null);
    }

    public Future<Void> updateSSLOptions(SSLOptions options) {
        return this.sslHelper.buildChannelProvider(new SSLOptions(options), this.listenContext).andThen(ar -> {
            if (ar.succeeded()) {
                this.sslChannelProvider.set((SslChannelProvider)ar.result());
            }
        }).mapEmpty();
    }

    public Future<TCPServerBase> bind(SocketAddress address) {
        ContextInternal listenContext = this.vertx.getOrCreateContext();
        return this.listen(address, listenContext).map(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Future<Channel> listen(SocketAddress localAddress, ContextInternal context) {
        Map<ServerID, ?> sharedNetServers;
        if (this.listening) {
            throw new IllegalStateException("Listen already called");
        }
        this.listenContext = context;
        this.listening = true;
        this.eventLoop = context.nettyEventLoop();
        Map<ServerID, ?> map = sharedNetServers = this.vertx.sharedTCPServers(this.getClass());
        synchronized (map) {
            SocketAddress bindAddress;
            boolean shared;
            TCPServerBase main;
            ServerID id;
            String hostOrPath;
            this.actualPort = localAddress.port();
            String string = hostOrPath = localAddress.isInetSocket() ? localAddress.host() : localAddress.path();
            if (this.actualPort > 0 || localAddress.isDomainSocket()) {
                id = new ServerID(this.actualPort, hostOrPath);
                main = (TCPServerBase)sharedNetServers.get(id);
                shared = true;
                bindAddress = localAddress;
            } else if (this.actualPort < 0) {
                id = new ServerID(this.actualPort, hostOrPath + "/" + -this.actualPort);
                main = (TCPServerBase)sharedNetServers.get(id);
                shared = true;
                bindAddress = SocketAddress.inetSocketAddress(0, localAddress.host());
            } else {
                id = new ServerID(this.actualPort, hostOrPath);
                main = null;
                shared = false;
                bindAddress = localAddress;
            }
            PromiseInternal<Channel> promise = this.listenContext.promise();
            if (main == null) {
                this.actualServer = this;
                this.bindFuture = promise;
                this.sslHelper = this.createSSLHelper();
                this.childHandler = this.childHandler(this.listenContext, localAddress);
                this.worker = ch -> this.childHandler.accept((Channel)ch, this.sslChannelProvider.get());
                this.servers = new HashSet<TCPServerBase>();
                this.servers.add(this);
                this.channelBalancer = new ServerChannelLoadBalancer(this.vertx.getAcceptorEventLoopGroup().next());
                if (shared) {
                    sharedNetServers.put(id, this);
                }
                this.listenContext.addCloseHook(this);
                this.sslHelper.buildChannelProvider(this.options.getSslOptions(), this.listenContext).onComplete(ar -> {
                    if (ar.succeeded()) {
                        this.sslChannelProvider.set((SslChannelProvider)ar.result());
                        this.channelBalancer.addWorker(this.eventLoop, this.worker);
                        ServerBootstrap bootstrap = new ServerBootstrap();
                        bootstrap.group(this.vertx.getAcceptorEventLoopGroup(), this.channelBalancer.workers());
                        if (this.options.isSsl()) {
                            bootstrap.childOption(ChannelOption.ALLOCATOR, PartialPooledByteBufAllocator.INSTANCE);
                        } else {
                            bootstrap.childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
                        }
                        bootstrap.childHandler(this.channelBalancer);
                        this.applyConnectionOptions(localAddress.isDomainSocket(), bootstrap);
                        com.arangodb.shaded.netty.util.concurrent.Future<Channel> bindFuture = AsyncResolveConnectHelper.doBind(this.vertx, bindAddress, bootstrap);
                        bindFuture.addListener(res -> {
                            if (res.isSuccess()) {
                                Channel ch = (Channel)res.getNow();
                                log.trace("Net server listening on " + hostOrPath + ":" + ch.localAddress());
                                if (shared) {
                                    ch.closeFuture().addListener(channelFuture -> {
                                        Map map = sharedNetServers;
                                        synchronized (map) {
                                            sharedNetServers.remove(id);
                                        }
                                    });
                                }
                                if (bindAddress.isInetSocket()) {
                                    this.actualPort = ((InetSocketAddress)ch.localAddress()).getPort();
                                }
                                this.metrics = this.createMetrics(localAddress);
                                promise.complete(ch);
                            } else {
                                promise.fail(res.cause());
                            }
                        });
                    } else {
                        promise.fail(ar.cause());
                    }
                });
                this.bindFuture.onFailure(err -> {
                    if (shared) {
                        Map map = sharedNetServers;
                        synchronized (map) {
                            sharedNetServers.remove(id);
                        }
                    }
                    this.listening = false;
                });
                return this.bindFuture;
            }
            this.actualServer = main;
            this.metrics = main.metrics;
            this.sslChannelProvider = main.sslChannelProvider;
            this.childHandler = this.childHandler(this.listenContext, localAddress);
            this.worker = ch -> this.childHandler.accept((Channel)ch, this.sslChannelProvider.get());
            this.actualServer.servers.add(this);
            this.actualServer.channelBalancer.addWorker(this.eventLoop, this.worker);
            this.listenContext.addCloseHook(this);
            main.bindFuture.onComplete(promise);
            return promise.future();
        }
    }

    public boolean isListening() {
        return this.listening;
    }

    protected TCPMetrics<?> createMetrics(SocketAddress localAddress) {
        return null;
    }

    private void applyConnectionOptions(boolean domainSocket, ServerBootstrap bootstrap) {
        this.vertx.transport().configure(this.options, domainSocket, bootstrap);
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public synchronized TCPMetrics<?> getMetrics() {
        return this.actualServer != null ? this.actualServer.metrics : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(Promise<Void> completion) {
        Map<ServerID, ?> servers;
        if (!this.listening) {
            completion.complete();
            return;
        }
        this.listening = false;
        this.listenContext.removeCloseHook(this);
        Map<ServerID, ?> map = servers = this.vertx.sharedTCPServers(this.getClass());
        synchronized (map) {
            ServerChannelLoadBalancer balancer = this.actualServer.channelBalancer;
            balancer.removeWorker(this.eventLoop, this.worker);
            if (balancer.hasHandlers()) {
                completion.complete();
            } else {
                this.actualServer.actualClose(completion);
            }
        }
    }

    private void actualClose(Promise<Void> done) {
        this.channelBalancer.close();
        this.bindFuture.onComplete(ar -> {
            if (ar.succeeded()) {
                Channel channel = (Channel)ar.result();
                ChannelFuture a = channel.close();
                if (this.metrics != null) {
                    a.addListener((GenericFutureListener<? extends com.arangodb.shaded.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<com.arangodb.shaded.netty.util.concurrent.Future>)cg -> this.metrics.close()));
                }
                a.addListener((PromiseInternal)done);
            } else {
                done.complete();
            }
        });
    }

    public abstract Future<Void> close();
}

