/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.net.impl.pool;

import com.arangodb.shaded.vertx.core.net.impl.pool.Executor;
import com.arangodb.shaded.vertx.core.net.impl.pool.Task;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SemaphoreExecutor<S>
implements Executor<S> {
    private final Lock lock = new ReentrantLock();
    private final S state;

    public SemaphoreExecutor(S state) {
        this.state = state;
    }

    @Override
    public void submit(Executor.Action<S> action) {
        this.lock.lock();
        Task post = null;
        try {
            post = action.execute(this.state);
        }
        finally {
            this.lock.unlock();
            if (post != null) {
                post.run();
            }
        }
    }
}

