/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.spi.resolver;

import com.arangodb.shaded.netty.resolver.AddressResolverGroup;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.Vertx;
import com.arangodb.shaded.vertx.core.VertxException;
import com.arangodb.shaded.vertx.core.dns.AddressResolverOptions;
import com.arangodb.shaded.vertx.core.impl.VertxImpl;
import com.arangodb.shaded.vertx.core.impl.logging.Logger;
import com.arangodb.shaded.vertx.core.impl.logging.LoggerFactory;
import com.arangodb.shaded.vertx.core.impl.resolver.DefaultResolverProvider;
import com.arangodb.shaded.vertx.core.impl.resolver.DnsResolverProvider;
import java.net.InetSocketAddress;

public interface ResolverProvider {
    public static final String DISABLE_DNS_RESOLVER_PROP_NAME = "vertx.disableDnsResolver";

    public static ResolverProvider factory(Vertx vertx, AddressResolverOptions options) {
        try {
            if (!Boolean.getBoolean(DISABLE_DNS_RESOLVER_PROP_NAME)) {
                return new DnsResolverProvider((VertxImpl)vertx, options);
            }
        }
        catch (Throwable e) {
            if (e instanceof VertxException) {
                throw e;
            }
            Logger logger = LoggerFactory.getLogger(ResolverProvider.class);
            logger.info("Using the default address resolver as the dns resolver could not be loaded");
        }
        return new DefaultResolverProvider();
    }

    public AddressResolverGroup<InetSocketAddress> resolver(AddressResolverOptions var1);

    public void close(Handler<Void> var1);
}

