/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.streams.impl;

import com.arangodb.shaded.vertx.core.Context;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import java.util.ArrayDeque;
import java.util.Collection;

public class InboundBuffer<E> {
    public static final Object END_SENTINEL = new Object();
    private final ContextInternal context;
    private ArrayDeque<E> pending;
    private final long highWaterMark;
    private long demand;
    private Handler<E> handler;
    private boolean overflow;
    private Handler<Void> drainHandler;
    private Handler<Void> emptyHandler;
    private Handler<Throwable> exceptionHandler;
    private boolean emitting;

    public InboundBuffer(Context context) {
        this(context, 16L);
    }

    public InboundBuffer(Context context, long highWaterMark) {
        if (context == null) {
            throw new NullPointerException("context must not be null");
        }
        if (highWaterMark < 0L) {
            throw new IllegalArgumentException("highWaterMark " + highWaterMark + " >= 0");
        }
        this.context = (ContextInternal)context;
        this.highWaterMark = highWaterMark;
        this.demand = Long.MAX_VALUE;
        this.pending = null;
    }

    private void checkThread() {
        if (!this.context.inThread()) {
            throw new IllegalStateException("This operation must be called from a Vert.x thread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(E element) {
        Handler<E> handler;
        this.checkThread();
        InboundBuffer inboundBuffer = this;
        synchronized (inboundBuffer) {
            if (this.demand == 0L || this.emitting) {
                if (this.pending == null) {
                    this.pending = new ArrayDeque(1);
                }
                this.pending.add(element);
                return this.checkWritable();
            }
            if (this.demand != Long.MAX_VALUE) {
                --this.demand;
            }
            this.emitting = true;
            handler = this.handler;
        }
        this.handleEvent(handler, element);
        return this.emitPending();
    }

    private boolean checkWritable() {
        if (this.demand == Long.MAX_VALUE) {
            return true;
        }
        long actual = (long)this.size() - this.demand;
        boolean writable = actual < this.highWaterMark;
        this.overflow |= !writable;
        return writable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(Iterable<E> elements) {
        this.checkThread();
        InboundBuffer inboundBuffer = this;
        synchronized (inboundBuffer) {
            if (this.pending == null) {
                int requiredCapacity = elements instanceof Collection ? ((Collection)elements).size() : 1;
                this.pending = new ArrayDeque(requiredCapacity);
            }
            for (E element : elements) {
                this.pending.add(element);
            }
            if (this.demand == 0L || this.emitting) {
                return this.checkWritable();
            }
            this.emitting = true;
        }
        return this.emitPending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean emitPending() {
        while (true) {
            Handler<E> h;
            E element;
            InboundBuffer inboundBuffer = this;
            synchronized (inboundBuffer) {
                int size = this.size();
                if (this.demand == 0L) {
                    this.emitting = false;
                    boolean writable = (long)size < this.highWaterMark;
                    this.overflow |= !writable;
                    return writable;
                }
                if (size == 0) {
                    this.emitting = false;
                    return true;
                }
                if (this.demand != Long.MAX_VALUE) {
                    --this.demand;
                }
                assert (this.pending != null);
                element = this.pending.poll();
                h = this.handler;
            }
            this.handleEvent(h, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drain() {
        Handler<Void> emptyHandler;
        Handler<Void> drainHandler;
        int emitted = 0;
        while (true) {
            Handler<E> handler;
            E element;
            InboundBuffer inboundBuffer = this;
            synchronized (inboundBuffer) {
                int size = this.size();
                if (size == 0) {
                    this.emitting = false;
                    if (this.overflow) {
                        this.overflow = false;
                        drainHandler = this.drainHandler;
                    } else {
                        drainHandler = null;
                    }
                    emptyHandler = emitted > 0 ? this.emptyHandler : null;
                    break;
                }
                if (this.demand == 0L) {
                    this.emitting = false;
                    return;
                }
                ++emitted;
                if (this.demand != Long.MAX_VALUE) {
                    --this.demand;
                }
                assert (this.pending != null);
                element = this.pending.poll();
                handler = this.handler;
            }
            this.handleEvent(handler, element);
        }
        if (drainHandler != null) {
            this.handleEvent(drainHandler, null);
        }
        if (emptyHandler != null) {
            this.handleEvent(emptyHandler, null);
        }
    }

    private <T> void handleEvent(Handler<T> handler, T element) {
        if (handler != null) {
            try {
                handler.handle(element);
            }
            catch (Throwable t) {
                this.handleException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Throwable err) {
        Handler<Throwable> handler;
        InboundBuffer inboundBuffer = this;
        synchronized (inboundBuffer) {
            handler = this.exceptionHandler;
            if (handler == null) {
                return;
            }
        }
        handler.handle(err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fetch(long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException();
        }
        InboundBuffer inboundBuffer = this;
        synchronized (inboundBuffer) {
            this.demand += amount;
            if (this.demand < 0L) {
                this.demand = Long.MAX_VALUE;
            }
            if (this.emitting || this.isEmpty() && !this.overflow) {
                return false;
            }
            this.emitting = true;
        }
        this.context.runOnContext(v -> this.drain());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E read() {
        InboundBuffer inboundBuffer = this;
        synchronized (inboundBuffer) {
            if (this.isEmpty()) {
                return null;
            }
            return this.pending.poll();
        }
    }

    public synchronized InboundBuffer<E> clear() {
        if (this.isEmpty()) {
            return this;
        }
        this.pending.clear();
        return this;
    }

    public synchronized InboundBuffer<E> pause() {
        this.demand = 0L;
        return this;
    }

    public boolean resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    public synchronized InboundBuffer<E> handler(Handler<E> handler) {
        this.handler = handler;
        return this;
    }

    public synchronized InboundBuffer<E> drainHandler(Handler<Void> handler) {
        this.drainHandler = handler;
        return this;
    }

    public synchronized InboundBuffer<E> emptyHandler(Handler<Void> handler) {
        this.emptyHandler = handler;
        return this;
    }

    public synchronized InboundBuffer<E> exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public synchronized boolean isEmpty() {
        if (this.pending == null) {
            return true;
        }
        return this.pending.isEmpty();
    }

    public synchronized boolean isWritable() {
        return (long)this.size() < this.highWaterMark;
    }

    public synchronized boolean isPaused() {
        return this.demand == 0L;
    }

    public synchronized int size() {
        return this.pending == null ? 0 : this.pending.size();
    }
}

