/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.ext.auth;

import com.arangodb.shaded.vertx.codegen.annotations.DataObject;
import com.arangodb.shaded.vertx.core.json.JsonObject;
import com.arangodb.shaded.vertx.ext.auth.JWTOptionsConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@DataObject(generateConverter=true)
public class JWTOptions {
    private static final JsonObject EMPTY = new JsonObject(Collections.emptyMap());
    private int leeway = 0;
    private boolean ignoreExpiration;
    private String algorithm = "HS256";
    private JsonObject header = EMPTY;
    private boolean noTimestamp;
    private int expires;
    private List<String> audience;
    private String issuer;
    private String subject;
    private List<String> permissions;
    private String nonceAlgorithm;

    public JWTOptions() {
    }

    public JWTOptions(JWTOptions other) {
        this.leeway = other.leeway;
        this.ignoreExpiration = other.ignoreExpiration;
        this.algorithm = other.algorithm;
        this.header = other.header;
        this.noTimestamp = other.noTimestamp;
        this.expires = other.expires;
        this.audience = other.audience;
        this.issuer = other.issuer;
        this.subject = other.subject;
        this.permissions = other.permissions;
        this.nonceAlgorithm = other.nonceAlgorithm;
    }

    public JWTOptions(JsonObject json) {
        JWTOptionsConverter.fromJson(json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        JWTOptionsConverter.toJson(this, json);
        return json;
    }

    public int getLeeway() {
        return this.leeway;
    }

    public JWTOptions setLeeway(int leeway) {
        this.leeway = leeway;
        return this;
    }

    public boolean isIgnoreExpiration() {
        return this.ignoreExpiration;
    }

    public JWTOptions setIgnoreExpiration(boolean ignoreExpiration) {
        this.ignoreExpiration = ignoreExpiration;
        return this;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public JWTOptions setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public JsonObject getHeader() {
        return this.header;
    }

    public JWTOptions setHeader(JsonObject header) {
        this.header = header;
        return this;
    }

    public boolean isNoTimestamp() {
        return this.noTimestamp;
    }

    public JWTOptions setNoTimestamp(boolean noTimestamp) {
        this.noTimestamp = noTimestamp;
        return this;
    }

    public int getExpiresInSeconds() {
        return this.expires;
    }

    public JWTOptions setExpiresInSeconds(int expires) {
        this.expires = expires;
        return this;
    }

    public JWTOptions setExpiresInMinutes(int expiresInMinutes) {
        this.expires = expiresInMinutes * 60;
        return this;
    }

    public List<String> getAudience() {
        return this.audience;
    }

    public JWTOptions setAudience(List<String> audience) {
        this.audience = audience;
        return this;
    }

    public JWTOptions addAudience(String audience) {
        if (this.audience == null) {
            this.audience = new ArrayList<String>();
        }
        this.audience.add(audience);
        return this;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public JWTOptions setIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public JWTOptions setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    @Deprecated
    public JWTOptions setPermissions(List<String> permissions) {
        this.permissions = permissions;
        return this;
    }

    @Deprecated
    public JWTOptions addPermission(String permission) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<String>();
        }
        this.permissions.add(permission);
        return this;
    }

    @Deprecated
    public List<String> getPermissions() {
        return this.permissions;
    }

    public String getNonceAlgorithm() {
        return this.nonceAlgorithm;
    }

    public JWTOptions setNonceAlgorithm(String nonceAlgorithm) {
        this.nonceAlgorithm = nonceAlgorithm;
        return this;
    }
}

