/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.ext.auth;

import com.arangodb.shaded.vertx.codegen.annotations.Fluent;
import com.arangodb.shaded.vertx.codegen.annotations.Nullable;
import com.arangodb.shaded.vertx.codegen.annotations.VertxGen;
import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.Promise;
import com.arangodb.shaded.vertx.core.json.JsonObject;
import com.arangodb.shaded.vertx.ext.auth.AuthProvider;
import com.arangodb.shaded.vertx.ext.auth.authorization.Authorization;
import com.arangodb.shaded.vertx.ext.auth.authorization.Authorizations;
import com.arangodb.shaded.vertx.ext.auth.authorization.RoleBasedAuthorization;
import com.arangodb.shaded.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization;
import com.arangodb.shaded.vertx.ext.auth.authorization.impl.AuthorizationsImpl;
import com.arangodb.shaded.vertx.ext.auth.impl.UserImpl;

@VertxGen
public interface User {
    public static User fromName(String username) {
        return User.create(new JsonObject().put("username", username));
    }

    public static User fromToken(String token) {
        return User.create(new JsonObject().put("access_token", token));
    }

    public static User create(JsonObject principal) {
        return User.create(principal, new JsonObject());
    }

    public static User create(JsonObject principal, JsonObject attributes) {
        return new UserImpl(principal, attributes);
    }

    default public @Nullable String subject() {
        JsonObject idToken;
        if (this.principal().containsKey("username")) {
            return this.principal().getString("username");
        }
        if (this.principal().containsKey("userHandle")) {
            return this.principal().getString("userHandle");
        }
        if (this.attributes().containsKey("idToken") && (idToken = this.attributes().getJsonObject("idToken")).containsKey("sub")) {
            return idToken.getString("sub");
        }
        return (String)this.get("sub");
    }

    public JsonObject attributes();

    default public boolean expired() {
        return this.expired(this.attributes().getInteger("leeway", 0));
    }

    default public boolean expired(int leeway) {
        Long nbf;
        Long iat;
        long now = System.currentTimeMillis() / 1000L;
        if (this.containsKey("exp") && now - (long)leeway >= this.attributes().getLong("exp", this.principal().getLong("exp", 0L))) {
            return true;
        }
        if (this.containsKey("iat") && (iat = this.attributes().getLong("iat", this.principal().getLong("iat", 0L))) > now + (long)leeway) {
            return true;
        }
        return this.containsKey("nbf") && (nbf = this.attributes().getLong("nbf", this.principal().getLong("nbf", 0L))) > now + (long)leeway;
    }

    default public <T> @Nullable T get(String key) {
        if (this.attributes().containsKey("rootClaim")) {
            JsonObject rootClaim;
            try {
                rootClaim = this.attributes().getJsonObject(this.attributes().getString("rootClaim"));
            }
            catch (ClassCastException e) {
                rootClaim = null;
            }
            if (rootClaim != null && rootClaim.containsKey(key)) {
                return (T)rootClaim.getValue(key);
            }
        }
        if (this.attributes().containsKey(key)) {
            return (T)this.attributes().getValue(key);
        }
        if (this.principal().containsKey(key)) {
            return (T)this.principal().getValue(key);
        }
        return null;
    }

    default public <T> @Nullable T getOrDefault(String key, T defaultValue) {
        if (this.attributes().containsKey("rootClaim")) {
            JsonObject rootClaim;
            try {
                rootClaim = this.attributes().getJsonObject(this.attributes().getString("rootClaim"));
            }
            catch (ClassCastException e) {
                rootClaim = null;
            }
            if (rootClaim != null && rootClaim.containsKey(key)) {
                return (T)rootClaim.getValue(key);
            }
        }
        if (this.attributes().containsKey(key)) {
            return (T)this.attributes().getValue(key);
        }
        if (this.principal().containsKey(key)) {
            return (T)this.principal().getValue(key);
        }
        return defaultValue;
    }

    default public boolean containsKey(String key) {
        if (this.attributes().containsKey("rootClaim")) {
            JsonObject rootClaim;
            try {
                rootClaim = this.attributes().getJsonObject(this.attributes().getString("rootClaim"));
            }
            catch (ClassCastException e) {
                rootClaim = null;
            }
            if (rootClaim != null && rootClaim.containsKey(key)) {
                return true;
            }
        }
        return this.attributes().containsKey(key) || this.principal().containsKey(key);
    }

    default public Authorizations authorizations() {
        return new AuthorizationsImpl();
    }

    @Fluent
    @Deprecated
    public User isAuthorized(Authorization var1, Handler<AsyncResult<Boolean>> var2);

    @Fluent
    @Deprecated
    default public User isAuthorized(String authority, Handler<AsyncResult<Boolean>> resultHandler) {
        return this.isAuthorized(authority.startsWith("role:") ? RoleBasedAuthorization.create(authority.substring(5)) : WildcardPermissionBasedAuthorization.create(authority), resultHandler);
    }

    @Deprecated
    default public Future<Boolean> isAuthorized(Authorization authority) {
        Promise<Boolean> promise = Promise.promise();
        this.isAuthorized(authority, promise);
        return promise.future();
    }

    @Deprecated
    default public Future<Boolean> isAuthorized(String authority) {
        return this.isAuthorized(authority.startsWith("role:") ? RoleBasedAuthorization.create(authority.substring(5)) : WildcardPermissionBasedAuthorization.create(authority));
    }

    @Fluent
    @Deprecated
    default public User clearCache() {
        this.authorizations().clear();
        return this;
    }

    public JsonObject principal();

    @Deprecated
    public void setAuthProvider(AuthProvider var1);

    @Fluent
    public User merge(User var1);

    default public boolean hasAmr(String value) {
        if (this.principal().containsKey("amr")) {
            return this.principal().getJsonArray("amr").contains(value);
        }
        return false;
    }
}

