/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.ext.auth.impl.http;

import com.arangodb.shaded.vertx.codegen.annotations.Nullable;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Vertx;
import com.arangodb.shaded.vertx.core.buffer.Buffer;
import com.arangodb.shaded.vertx.core.http.HttpClient;
import com.arangodb.shaded.vertx.core.http.HttpClientOptions;
import com.arangodb.shaded.vertx.core.http.HttpClientResponse;
import com.arangodb.shaded.vertx.core.http.HttpMethod;
import com.arangodb.shaded.vertx.core.http.RequestOptions;
import com.arangodb.shaded.vertx.core.json.JsonArray;
import com.arangodb.shaded.vertx.core.json.JsonObject;
import com.arangodb.shaded.vertx.ext.auth.impl.http.SimpleHttpResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.function.Function;

public final class SimpleHttpClient {
    private final HttpClient client;
    private final String userAgent;

    public SimpleHttpClient(Vertx vertx, String userAgent, HttpClientOptions options) {
        this.client = vertx.createHttpClient(options);
        this.userAgent = userAgent;
    }

    public Future<SimpleHttpResponse> fetch(HttpMethod method, String url, JsonObject headers, Buffer payload) {
        if (url == null || url.length() == 0) {
            return Future.failedFuture("Invalid url");
        }
        RequestOptions options = new RequestOptions().setMethod(method).setAbsoluteURI(url);
        if (this.userAgent != null) {
            options.addHeader("User-Agent", this.userAgent);
        }
        if (headers != null) {
            for (Map.Entry<String, Object> kv : headers) {
                options.addHeader(kv.getKey(), (String)kv.getValue());
            }
        }
        if (method != HttpMethod.POST && method != HttpMethod.PATCH && method != HttpMethod.PUT) {
            payload = null;
        }
        return this.makeRequest(options, payload);
    }

    public static Buffer jsonToQuery(JsonObject json) {
        Buffer buffer = Buffer.buffer();
        try {
            for (Map.Entry<String, Object> kv : json) {
                if (buffer.length() != 0) {
                    buffer.appendByte((byte)38);
                }
                buffer.appendString(URLEncoder.encode(kv.getKey(), "UTF-8"));
                buffer.appendByte((byte)61);
                Object v = kv.getValue();
                if (v == null) continue;
                buffer.appendString(URLEncoder.encode(v.toString(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    public static @Nullable JsonObject queryToJson(Buffer query) throws UnsupportedEncodingException {
        String[] pairs;
        if (query == null) {
            return null;
        }
        JsonObject json = new JsonObject();
        for (String pair : pairs = query.toString().split("&")) {
            JsonArray array;
            String value;
            int idx = pair.indexOf("=");
            String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
            String string = value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
            if (!json.containsKey(key)) {
                json.put(key, value);
                continue;
            }
            Object oldValue = json.getValue(key);
            if (oldValue instanceof JsonArray) {
                array = (JsonArray)oldValue;
            } else {
                array = new JsonArray();
                array.add(oldValue);
                json.put(key, array);
            }
            if (value == null) {
                array.addNull();
                continue;
            }
            array.add(value);
        }
        return json;
    }

    private Future<SimpleHttpResponse> makeRequest(RequestOptions options, Buffer payload) {
        return this.client.request(options).compose(req -> {
            Function<HttpClientResponse, Future> resultHandler = res -> res.body().compose(value -> {
                if (res.statusCode() < 200 || res.statusCode() >= 300) {
                    if (value == null || value.length() == 0) {
                        return Future.failedFuture(res.statusMessage());
                    }
                    return Future.failedFuture(res.statusMessage() + ": " + value);
                }
                return Future.succeededFuture(new SimpleHttpResponse(res.statusCode(), res.headers(), (Buffer)value));
            });
            if (payload != null) {
                return req.send(payload).compose(resultHandler);
            }
            return req.send().compose(resultHandler);
        });
    }
}

