/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.ext.web.client;

import com.arangodb.shaded.vertx.core.json.JsonObject;
import com.arangodb.shaded.vertx.core.json.impl.JsonUtil;
import com.arangodb.shaded.vertx.ext.web.client.WebClientOptions;
import com.arangodb.shaded.vertx.uritemplate.ExpandOptions;
import java.util.Base64;
import java.util.Map;

public class WebClientOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, WebClientOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "followRedirects": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setFollowRedirects((Boolean)member.getValue());
                    break;
                }
                case "templateExpandOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setTemplateExpandOptions(new ExpandOptions((JsonObject)member.getValue()));
                    break;
                }
                case "userAgent": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUserAgent((String)member.getValue());
                    break;
                }
                case "userAgentEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setUserAgentEnabled((Boolean)member.getValue());
                }
            }
        }
    }

    public static void toJson(WebClientOptions obj, JsonObject json) {
        WebClientOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(WebClientOptions obj, Map<String, Object> json) {
        json.put("followRedirects", obj.isFollowRedirects());
        if (obj.getTemplateExpandOptions() != null) {
            json.put("templateExpandOptions", obj.getTemplateExpandOptions().toJson());
        }
        if (obj.getUserAgent() != null) {
            json.put("userAgent", obj.getUserAgent());
        }
        json.put("userAgentEnabled", obj.isUserAgentEnabled());
    }
}

