/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.ext.web.client.impl.cache;

import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Vertx;
import com.arangodb.shaded.vertx.core.shareddata.AsyncMap;
import com.arangodb.shaded.vertx.core.shareddata.SharedData;
import com.arangodb.shaded.vertx.ext.web.client.impl.cache.CacheKey;
import com.arangodb.shaded.vertx.ext.web.client.impl.cache.CachedHttpResponse;
import com.arangodb.shaded.vertx.ext.web.client.spi.CacheStore;

public class SharedDataCacheStore
implements CacheStore {
    private static final String ASYNC_MAP_NAME = "HttpCacheStore";
    private final SharedData sharedData;

    public SharedDataCacheStore(Vertx vertx) {
        this.sharedData = vertx.sharedData();
    }

    @Override
    public Future<CachedHttpResponse> get(CacheKey key) {
        return this.asyncMap().compose(map -> map.get(key));
    }

    @Override
    public Future<CachedHttpResponse> set(CacheKey key, CachedHttpResponse response) {
        return this.asyncMap().compose(map -> map.put(key, response)).map(response);
    }

    @Override
    public Future<Void> delete(CacheKey key) {
        return this.asyncMap().compose(map -> map.remove(key)).mapEmpty();
    }

    @Override
    public Future<Void> flush() {
        return this.asyncMap().compose(AsyncMap::clear);
    }

    private Future<AsyncMap<CacheKey, CachedHttpResponse>> asyncMap() {
        return this.sharedData.getAsyncMap(ASYNC_MAP_NAME);
    }
}

