/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.ext.web.client.impl.cache;

import com.arangodb.shaded.vertx.core.MultiMap;
import com.arangodb.shaded.vertx.core.http.HttpHeaders;

public class UserAgent {
    private final NormalizedType type;

    static UserAgent parse(MultiMap headers) {
        String agent = headers.get(HttpHeaders.USER_AGENT);
        return new UserAgent(UserAgent.parseHeader(agent));
    }

    private UserAgent(NormalizedType type) {
        this.type = type;
    }

    public String normalize() {
        return this.type.name();
    }

    public NormalizedType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAgent userAgent = (UserAgent)o;
        return this.type.equals((Object)userAgent.type);
    }

    private static NormalizedType parseHeader(String string) {
        if (string == null) {
            return NormalizedType.DESKTOP;
        }
        return string.contains("Mobile") ? NormalizedType.MOBILE : NormalizedType.DESKTOP;
    }

    static enum NormalizedType {
        MOBILE,
        DESKTOP;

    }
}

