/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.ext.web.client.spi;

import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.Vertx;
import com.arangodb.shaded.vertx.ext.web.client.impl.cache.CacheKey;
import com.arangodb.shaded.vertx.ext.web.client.impl.cache.CachedHttpResponse;
import com.arangodb.shaded.vertx.ext.web.client.impl.cache.LocalCacheStore;
import com.arangodb.shaded.vertx.ext.web.client.impl.cache.NoOpCacheStore;
import com.arangodb.shaded.vertx.ext.web.client.impl.cache.SharedDataCacheStore;

public interface CacheStore {
    public static CacheStore build() {
        return new NoOpCacheStore();
    }

    public static CacheStore sharedDataStore(Vertx vertx) {
        return new SharedDataCacheStore(vertx);
    }

    public static CacheStore localStore() {
        return new LocalCacheStore();
    }

    public Future<CachedHttpResponse> get(CacheKey var1);

    public Future<CachedHttpResponse> set(CacheKey var1, CachedHttpResponse var2);

    public Future<Void> delete(CacheKey var1);

    public Future<Void> flush();

    default public void get(CacheKey key, Handler<AsyncResult<CachedHttpResponse>> handler) {
        this.get(key).onComplete(handler);
    }

    default public void set(CacheKey key, CachedHttpResponse response, Handler<AsyncResult<CachedHttpResponse>> handler) {
        this.set(key, response).onComplete(handler);
    }

    default public void delete(CacheKey key, Handler<AsyncResult<Void>> handler) {
        this.delete(key).onComplete(handler);
    }

    default public void flush(Handler<AsyncResult<Void>> handler) {
        this.flush().onComplete(handler);
    }
}

