/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.ext.web.codec;

import com.arangodb.shaded.vertx.codegen.annotations.GenIgnore;
import com.arangodb.shaded.vertx.codegen.annotations.VertxGen;
import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.buffer.Buffer;
import com.arangodb.shaded.vertx.core.json.JsonArray;
import com.arangodb.shaded.vertx.core.json.JsonObject;
import com.arangodb.shaded.vertx.core.parsetools.JsonParser;
import com.arangodb.shaded.vertx.core.streams.WriteStream;
import com.arangodb.shaded.vertx.ext.web.codec.impl.BodyCodecImpl;
import com.arangodb.shaded.vertx.ext.web.codec.impl.JsonStreamBodyCodec;
import com.arangodb.shaded.vertx.ext.web.codec.impl.StreamingBodyCodec;
import com.arangodb.shaded.vertx.ext.web.codec.spi.BodyStream;
import java.util.function.Function;

@VertxGen
public interface BodyCodec<T> {
    public static BodyCodec<String> string() {
        return BodyCodecImpl.STRING;
    }

    public static BodyCodec<String> string(String encoding) {
        return BodyCodecImpl.string(encoding);
    }

    public static BodyCodec<Buffer> buffer() {
        return BodyCodecImpl.BUFFER;
    }

    public static BodyCodec<JsonObject> jsonObject() {
        return BodyCodecImpl.JSON_OBJECT;
    }

    public static BodyCodec<JsonArray> jsonArray() {
        return BodyCodecImpl.JSON_ARRAY;
    }

    public static <U> BodyCodec<U> json(Class<U> type) {
        return BodyCodecImpl.json(type);
    }

    public static BodyCodec<Void> none() {
        return BodyCodecImpl.NONE;
    }

    public static <T> BodyCodec<T> create(Function<Buffer, T> decode) {
        return new BodyCodecImpl<T>(decode);
    }

    public static BodyCodec<Void> pipe(WriteStream<Buffer> stream) {
        return BodyCodec.pipe(stream, true);
    }

    public static BodyCodec<Void> pipe(WriteStream<Buffer> stream, boolean close) {
        StreamingBodyCodec bodyCodec = new StreamingBodyCodec(stream, close);
        bodyCodec.init();
        return bodyCodec;
    }

    public static BodyCodec<Void> jsonStream(JsonParser parser) {
        return new JsonStreamBodyCodec(parser);
    }

    @GenIgnore
    public void create(Handler<AsyncResult<BodyStream<T>>> var1);
}

