/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.vst;

import com.arangodb.ArangoDBException;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.InternalResponse;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.internal.net.AccessType;
import com.arangodb.internal.net.Host;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.serde.InternalSerde;
import com.arangodb.internal.util.RequestUtils;
import com.arangodb.internal.util.ResponseUtils;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackParserException;
import com.arangodb.vst.internal.Chunk;
import com.arangodb.vst.internal.Message;
import com.arangodb.vst.internal.VstConnection;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VstCommunication<R, C extends VstConnection<?>>
implements Closeable {
    protected static final String ENCRYPTION_PLAIN = "plain";
    protected static final String ENCRYPTION_JWT = "jwt";
    protected static final AtomicLong mId = new AtomicLong(0L);
    private static final Logger LOGGER = LoggerFactory.getLogger(VstCommunication.class);
    protected final InternalSerde serde;
    private static final String X_ARANGO_DRIVER = "JavaDriver/7.1.0 (JVM/" + System.getProperty("java.specification.version") + ")";
    protected final String user;
    protected final String password;
    protected final Integer chunkSize;
    protected final HostHandler hostHandler;
    protected volatile String jwt;

    protected VstCommunication(ArangoConfig config, HostHandler hostHandler) {
        this.user = config.getUser();
        this.password = config.getPassword();
        this.jwt = config.getJwt();
        this.serde = config.getInternalSerde();
        this.chunkSize = config.getChunkSize();
        this.hostHandler = hostHandler;
    }

    protected synchronized C connect(HostHandle hostHandle, AccessType accessType) {
        Host host = this.hostHandler.get(hostHandle, accessType);
        while (true) {
            if (host == null) {
                this.hostHandler.reset();
                throw new ArangoDBException("Was not able to connect to any host");
            }
            VstConnection connection = (VstConnection)host.connection();
            if (connection.isOpen()) {
                this.hostHandler.success();
                return (C)connection;
            }
            try {
                connection.open();
                this.hostHandler.success();
                if (this.jwt != null || this.user != null) {
                    this.tryAuthenticate(connection);
                }
                this.hostHandler.confirm();
                if (!connection.isOpen()) {
                    this.hostHandler.fail(new IOException("The connection is closed."));
                    host = this.hostHandler.get(hostHandle, accessType);
                    continue;
                }
                return (C)connection;
            }
            catch (IOException e) {
                this.hostHandler.fail(e);
                if (hostHandle != null && hostHandle.getHost() != null) {
                    hostHandle.setHost(null);
                }
                Host failedHost = host;
                host = this.hostHandler.get(hostHandle, accessType);
                if (host != null) {
                    LOGGER.warn(String.format("Could not connect to %s", failedHost.getDescription()), (Throwable)e);
                    LOGGER.warn(String.format("Could not connect to %s or SSL Handshake failed. Try connecting to %s", failedHost.getDescription(), host.getDescription()));
                    continue;
                }
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new ArangoDBException(e);
            }
            break;
        }
    }

    private void tryAuthenticate(C connection) {
        try {
            this.authenticate(connection);
        }
        catch (ArangoDBException authException) {
            ((VstConnection)connection).close();
            throw authException;
        }
    }

    protected abstract void authenticate(C var1);

    @Override
    public void close() throws IOException {
        this.hostHandler.close();
    }

    public R execute(InternalRequest request, HostHandle hostHandle) {
        return this.execute(request, (C)hostHandle, 0);
    }

    protected R execute(InternalRequest request, HostHandle hostHandle, int attemptCount) {
        C connection = this.connect(hostHandle, RequestUtils.determineAccessType(request));
        return this.execute(request, connection, attemptCount);
    }

    protected abstract R execute(InternalRequest var1, C var2);

    protected abstract R execute(InternalRequest var1, C var2, int var3);

    protected void checkError(InternalResponse response) {
        ResponseUtils.checkError(this.serde, response);
    }

    protected InternalResponse createResponse(Message message) throws VPackParserException {
        InternalResponse response = this.serde.deserialize(message.getHead().toByteArray(), InternalResponse.class);
        if (message.getBody() != null) {
            response.setBody(message.getBody().toByteArray());
        }
        return response;
    }

    protected final Message createMessage(InternalRequest request) throws VPackParserException {
        request.putHeaderParam("accept", "application/x-velocypack");
        request.putHeaderParam("content-type", "application/x-velocypack");
        request.putHeaderParam("x-arango-driver", X_ARANGO_DRIVER);
        long id = mId.incrementAndGet();
        return new Message(id, this.serde.serialize(request), request.getBody());
    }

    protected Collection<Chunk> buildChunks(Message message) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        VPackSlice head = message.getHead();
        int size = head.getByteSize();
        VPackSlice body = message.getBody();
        if (body != null) {
            size += body.getByteSize();
        }
        int n = size / this.chunkSize;
        int numberOfChunks = size % this.chunkSize != 0 ? n + 1 : n;
        int off = 0;
        int i = 0;
        while (size > 0) {
            int len = Math.min(this.chunkSize, size);
            long messageLength = i == 0 && numberOfChunks > 1 ? (long)size : -1L;
            Chunk chunk = new Chunk(message.getId(), i, numberOfChunks, messageLength, off, len);
            size -= len;
            off += len;
            chunks.add(chunk);
            ++i;
        }
        return chunks;
    }

    public void setJwt(String jwt) {
        this.jwt = jwt;
    }
}

