/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.vst;

import com.arangodb.ArangoDBException;
import com.arangodb.config.HostDescription;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.InternalResponse;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.internal.net.ArangoDBRedirectException;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.util.HostUtils;
import com.arangodb.velocypack.exception.VPackParserException;
import com.arangodb.vst.VstCommunication;
import com.arangodb.vst.internal.AuthenticationRequest;
import com.arangodb.vst.internal.JwtAuthenticationRequest;
import com.arangodb.vst.internal.Message;
import com.arangodb.vst.internal.VstConnectionSync;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VstCommunicationSync
extends VstCommunication<InternalResponse, VstConnectionSync> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VstCommunicationSync.class);

    public VstCommunicationSync(ArangoConfig config, HostHandler hostHandler) {
        super(config, hostHandler);
    }

    @Override
    protected InternalResponse execute(InternalRequest request, VstConnectionSync connection) {
        return this.execute(request, connection, 0);
    }

    @Override
    protected InternalResponse execute(InternalRequest request, VstConnectionSync connection, int attemptCount) {
        try {
            Message requestMessage = this.createMessage(request);
            if (LOGGER.isDebugEnabled()) {
                String body = request.getBody() == null ? "" : this.serde.toJsonString(request.getBody());
                LOGGER.debug("Send Request [id={}]: {} {}", new Object[]{requestMessage.getId(), request, body});
            }
            Message responseMessage = this.send(requestMessage, connection);
            InternalResponse response = this.createResponse(responseMessage);
            if (LOGGER.isDebugEnabled()) {
                String body = response.getBody() == null ? "" : this.serde.toJsonString(response.getBody());
                LOGGER.debug("Received Response [id={}]: {} {}", new Object[]{responseMessage.getId(), response, body});
            }
            this.checkError(response);
            return response;
        }
        catch (VPackParserException e) {
            throw new ArangoDBException(e);
        }
        catch (ArangoDBRedirectException e) {
            if (attemptCount >= 3) {
                throw e;
            }
            String location = e.getLocation();
            HostDescription redirectHost = HostUtils.createFromLocation(location);
            this.hostHandler.failIfNotMatch(redirectHost, e);
            return (InternalResponse)this.execute(request, new HostHandle().setHost(redirectHost), attemptCount + 1);
        }
    }

    private Message send(Message message, VstConnectionSync connection) {
        return connection.write(message, (Collection)this.buildChunks(message));
    }

    @Override
    protected void authenticate(VstConnectionSync connection) {
        InternalRequest authRequest = this.jwt != null ? new JwtAuthenticationRequest(this.jwt, "jwt") : new AuthenticationRequest(this.user, this.password != null ? this.password : "", "plain");
        InternalResponse response = this.execute(authRequest, connection);
        this.checkError(response);
    }
}

