/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.vst.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.config.HostDescription;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.vst.internal.Chunk;
import com.arangodb.vst.internal.Message;
import com.arangodb.vst.internal.VstConnection;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

public class VstConnectionSync
extends VstConnection<Message> {
    public VstConnectionSync(ArangoConfig config, HostDescription host) {
        super(config, host);
    }

    @Override
    public Message write(Message message, Collection<Chunk> chunks) {
        FutureTask<Message> task = new FutureTask<Message>(() -> this.messageStore.get(message.getId()));
        this.messageStore.storeMessage(message.getId(), task);
        super.writeIntern(message, chunks);
        try {
            return this.timeout == null || (long)this.timeout.intValue() == 0L ? task.get() : task.get(this.timeout.intValue(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw ArangoDBException.wrap(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ArangoDBException(e);
        }
        catch (Exception e) {
            throw ArangoDBException.wrap(e);
        }
    }

    @Override
    protected void doKeepAlive() {
        this.sendKeepAlive();
    }
}

