/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.entity.arangosearch.analyzer;

import com.arangodb.entity.arangosearch.AnalyzerFeature;
import com.arangodb.entity.arangosearch.AnalyzerType;
import com.arangodb.entity.arangosearch.analyzer.AQLAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.ClassificationAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.CollationAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.DelimiterAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.GeoJSONAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.GeoPointAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.GeoS2Analyzer;
import com.arangodb.entity.arangosearch.analyzer.IdentityAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.MinHashAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.MultiDelimiterAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.NGramAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.NearestNeighborsAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.NormAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.PipelineAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.SegmentationAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.StemAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.StopwordsAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.TextAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.WildcardAnalyzer;
import com.arangodb.shaded.fasterxml.jackson.annotation.JsonIgnore;
import com.arangodb.shaded.fasterxml.jackson.annotation.JsonSubTypes;
import com.arangodb.shaded.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="identity", value=IdentityAnalyzer.class), @JsonSubTypes.Type(name="delimiter", value=DelimiterAnalyzer.class), @JsonSubTypes.Type(name="multi_delimiter", value=MultiDelimiterAnalyzer.class), @JsonSubTypes.Type(name="stem", value=StemAnalyzer.class), @JsonSubTypes.Type(name="norm", value=NormAnalyzer.class), @JsonSubTypes.Type(name="ngram", value=NGramAnalyzer.class), @JsonSubTypes.Type(name="text", value=TextAnalyzer.class), @JsonSubTypes.Type(name="pipeline", value=PipelineAnalyzer.class), @JsonSubTypes.Type(name="stopwords", value=StopwordsAnalyzer.class), @JsonSubTypes.Type(name="aql", value=AQLAnalyzer.class), @JsonSubTypes.Type(name="geojson", value=GeoJSONAnalyzer.class), @JsonSubTypes.Type(name="geopoint", value=GeoPointAnalyzer.class), @JsonSubTypes.Type(name="geo_s2", value=GeoS2Analyzer.class), @JsonSubTypes.Type(name="segmentation", value=SegmentationAnalyzer.class), @JsonSubTypes.Type(name="collation", value=CollationAnalyzer.class), @JsonSubTypes.Type(name="classification", value=ClassificationAnalyzer.class), @JsonSubTypes.Type(name="nearest_neighbors", value=NearestNeighborsAnalyzer.class), @JsonSubTypes.Type(name="minhash", value=MinHashAnalyzer.class), @JsonSubTypes.Type(name="wildcard", value=WildcardAnalyzer.class)})
public abstract class SearchAnalyzer {
    private String name;
    private AnalyzerType type;
    private Collection<AnalyzerFeature> features;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public AnalyzerType getType() {
        return this.type;
    }

    public void setType(AnalyzerType type) {
        this.type = type;
    }

    public Set<AnalyzerFeature> getFeatures() {
        return this.features != null ? new HashSet<AnalyzerFeature>(this.features) : null;
    }

    public void setFeatures(Set<AnalyzerFeature> features) {
        this.features = features;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchAnalyzer that = (SearchAnalyzer)o;
        return Objects.equals(this.getName(), that.getName()) && this.getType() == that.getType() && Objects.equals(this.getFeatures(), that.getFeatures());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.features});
    }
}

