/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.http;

import com.arangodb.ArangoDBException;
import com.arangodb.Compression;
import com.arangodb.ContentType;
import com.arangodb.PackageVersion;
import com.arangodb.Protocol;
import com.arangodb.arch.UnstableApi;
import com.arangodb.config.HostDescription;
import com.arangodb.http.HttpProtocolConfig;
import com.arangodb.http.compression.Encoder;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.InternalResponse;
import com.arangodb.internal.RequestType;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.internal.net.Connection;
import com.arangodb.internal.serde.ContentTypeFactory;
import com.arangodb.internal.util.EncodeUtils;
import com.arangodb.shaded.netty.handler.ssl.ApplicationProtocolConfig;
import com.arangodb.shaded.netty.handler.ssl.CipherSuiteFilter;
import com.arangodb.shaded.netty.handler.ssl.ClientAuth;
import com.arangodb.shaded.netty.handler.ssl.IdentityCipherSuiteFilter;
import com.arangodb.shaded.netty.handler.ssl.JdkSslContext;
import com.arangodb.shaded.vertx.core.MultiMap;
import com.arangodb.shaded.vertx.core.Vertx;
import com.arangodb.shaded.vertx.core.VertxOptions;
import com.arangodb.shaded.vertx.core.buffer.Buffer;
import com.arangodb.shaded.vertx.core.http.HttpHeaders;
import com.arangodb.shaded.vertx.core.http.HttpMethod;
import com.arangodb.shaded.vertx.core.http.HttpVersion;
import com.arangodb.shaded.vertx.core.net.JdkSSLEngineOptions;
import com.arangodb.shaded.vertx.core.spi.tls.SslContextFactory;
import com.arangodb.shaded.vertx.ext.auth.authentication.TokenCredentials;
import com.arangodb.shaded.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import com.arangodb.shaded.vertx.ext.web.client.HttpRequest;
import com.arangodb.shaded.vertx.ext.web.client.HttpResponse;
import com.arangodb.shaded.vertx.ext.web.client.WebClient;
import com.arangodb.shaded.vertx.ext.web.client.WebClientOptions;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnstableApi
public class HttpConnection
implements Connection {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpConnection.class);
    private static final String CONTENT_TYPE_APPLICATION_JSON_UTF8 = "application/json; charset=utf-8";
    private static final String CONTENT_TYPE_VPACK = "application/x-velocypack";
    private static final String USER_AGENT = HttpConnection.getUserAgent();
    private static final AtomicInteger THREAD_COUNT = new AtomicInteger();
    private volatile String auth;
    private final int compressionThreshold;
    private final Encoder encoder;
    private final WebClient client;
    private final Integer timeout;
    private final MultiMap commonHeaders = MultiMap.caseInsensitiveMultiMap();
    private final Vertx vertxToClose;

    private static String getUserAgent() {
        return "JavaDriver/" + PackageVersion.VERSION + " (JVM/" + System.getProperty("java.specification.version") + ")";
    }

    HttpConnection(ArangoConfig config, HostDescription host, HttpProtocolConfig protocolConfig) {
        Vertx vertxToUse;
        Protocol protocol = config.getProtocol();
        ContentType contentType = ContentTypeFactory.of(protocol);
        if (contentType == ContentType.VPACK) {
            this.commonHeaders.add(HttpHeaders.ACCEPT.toString(), CONTENT_TYPE_VPACK);
            this.commonHeaders.add(HttpHeaders.CONTENT_TYPE.toString(), CONTENT_TYPE_VPACK);
        } else if (contentType == ContentType.JSON) {
            this.commonHeaders.add(HttpHeaders.ACCEPT.toString(), CONTENT_TYPE_APPLICATION_JSON_UTF8);
            this.commonHeaders.add(HttpHeaders.CONTENT_TYPE.toString(), CONTENT_TYPE_APPLICATION_JSON_UTF8);
        } else {
            throw new IllegalArgumentException("Unsupported protocol: " + (Object)((Object)protocol));
        }
        this.compressionThreshold = config.getCompressionThreshold();
        Compression compression = config.getCompression();
        this.encoder = Encoder.of(compression, config.getCompressionLevel());
        if (this.encoder.getFormat() != null) {
            this.commonHeaders.add(HttpHeaders.ACCEPT_ENCODING.toString(), this.encoder.getFormat());
        }
        this.commonHeaders.add("x-arango-driver", USER_AGENT);
        this.timeout = config.getTimeout();
        this.auth = new UsernamePasswordCredentials(config.getUser(), Optional.ofNullable(config.getPassword()).orElse("")).toHttpAuthorization();
        if (protocolConfig.getVertx() != null) {
            vertxToUse = protocolConfig.getVertx();
            this.vertxToClose = null;
            LOGGER.debug("Reusing existing Vert.x instance");
        } else {
            LOGGER.debug("Creating new Vert.x instance");
            vertxToUse = Vertx.vertx(new VertxOptions().setPreferNativeTransport(true).setEventLoopPoolSize(1));
            vertxToUse.runOnContext(e -> Thread.currentThread().setName("adb-http-" + THREAD_COUNT.getAndIncrement()));
            this.vertxToClose = vertxToUse;
        }
        int intTtl = Optional.ofNullable(config.getConnectionTtl()).map(ttl -> Math.toIntExact(ttl / 1000L)).orElse(0);
        final HttpVersion httpVersion = protocol == Protocol.HTTP_JSON || protocol == Protocol.HTTP_VPACK ? HttpVersion.HTTP_1_1 : HttpVersion.HTTP_2;
        WebClientOptions webClientOptions = new WebClientOptions().setMaxPoolSize(1).setHttp2MaxPoolSize(1).setConnectTimeout(this.timeout).setIdleTimeoutUnit(TimeUnit.MILLISECONDS).setIdleTimeout(this.timeout).setKeepAliveTimeout(intTtl).setHttp2KeepAliveTimeout(intTtl).setUserAgentEnabled(false).setFollowRedirects(false).setLogActivity(true).setKeepAlive(true).setTcpKeepAlive(true).setPipelining(true).setReuseAddress(true).setReusePort(true).setHttp2ClearTextUpgrade(false).setProtocolVersion(httpVersion).setDefaultHost(host.getHost()).setDefaultPort(host.getPort()).setProxyOptions(protocolConfig.getProxyOptions());
        if (compression != Compression.NONE) {
            webClientOptions.setTryUseCompression(true);
        }
        if (Boolean.TRUE.equals(config.getUseSsl())) {
            SSLContext ctx;
            if (config.getSslContext() != null) {
                ctx = config.getSslContext();
            } else {
                try {
                    ctx = SSLContext.getDefault();
                }
                catch (NoSuchAlgorithmException e2) {
                    throw ArangoDBException.of(e2);
                }
            }
            ((WebClientOptions)webClientOptions.setSsl(true).setUseAlpn(true).setAlpnVersions((List)Collections.singletonList(httpVersion))).setVerifyHost(config.getVerifyHost()).setJdkSslEngineOptions(new JdkSSLEngineOptions(){

                @Override
                public JdkSSLEngineOptions copy() {
                    return this;
                }

                @Override
                public SslContextFactory sslContextFactory() {
                    return () -> new JdkSslContext(ctx, true, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.FATAL_ALERT, ApplicationProtocolConfig.SelectedListenerFailureBehavior.FATAL_ALERT, httpVersion.alpnName()), ClientAuth.OPTIONAL, null, false);
                }
            });
        }
        this.client = WebClient.create(vertxToUse, webClientOptions);
    }

    private static String buildUrl(InternalRequest request) {
        StringBuilder sb = new StringBuilder();
        String dbName = request.getDbName();
        if (dbName != null && !dbName.isEmpty()) {
            sb.append("/_db/").append(EncodeUtils.encodeURIComponent(dbName));
        }
        sb.append(request.getPath());
        if (!request.getQueryParam().isEmpty()) {
            sb.append("?");
            Iterator<Map.Entry<String, String>> iterator = request.getQueryParam().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> param = iterator.next();
                if (param.getValue() == null) continue;
                sb.append(EncodeUtils.encodeURIComponent(param.getKey()));
                sb.append("=");
                sb.append(EncodeUtils.encodeURIComponent(param.getValue()));
                if (!iterator.hasNext()) continue;
                sb.append("&");
            }
        }
        return sb.toString();
    }

    private static void addHeader(InternalRequest request, HttpRequest<?> httpRequest) {
        for (Map.Entry<String, String> header : request.getHeaderParam().entrySet()) {
            httpRequest.putHeader(header.getKey(), header.getValue());
        }
    }

    @Override
    public void close() {
        this.client.close();
        if (this.vertxToClose != null) {
            LOGGER.debug("Closing Vert.x instance");
            this.vertxToClose.close();
        }
    }

    private HttpMethod requestTypeToHttpMethod(RequestType requestType) {
        switch (requestType) {
            case POST: {
                return HttpMethod.POST;
            }
            case PUT: {
                return HttpMethod.PUT;
            }
            case PATCH: {
                return HttpMethod.PATCH;
            }
            case DELETE: {
                return HttpMethod.DELETE;
            }
            case HEAD: {
                return HttpMethod.HEAD;
            }
        }
        return HttpMethod.GET;
    }

    @Override
    @UnstableApi
    public CompletableFuture<InternalResponse> executeAsync(@UnstableApi InternalRequest request) {
        CompletableFuture<InternalResponse> rfuture = new CompletableFuture<InternalResponse>();
        this.doExecute(request, rfuture);
        return rfuture;
    }

    public void doExecute(@UnstableApi InternalRequest request, @UnstableApi CompletableFuture<InternalResponse> rfuture) {
        Buffer buffer;
        String path = HttpConnection.buildUrl(request);
        HttpRequest<Buffer> httpRequest = this.client.request(this.requestTypeToHttpMethod(request.getRequestType()), path).timeout(this.timeout.intValue());
        httpRequest.putHeaders(this.commonHeaders);
        HttpConnection.addHeader(request, httpRequest);
        httpRequest.putHeader(HttpHeaders.AUTHORIZATION.toString(), this.auth);
        byte[] reqBody = request.getBody();
        if (reqBody == null) {
            buffer = Buffer.buffer();
        } else if (reqBody.length > this.compressionThreshold) {
            httpRequest.putHeader(HttpHeaders.CONTENT_ENCODING.toString(), this.encoder.getFormat());
            buffer = this.encoder.encode(reqBody);
        } else {
            buffer = Buffer.buffer(reqBody);
        }
        try {
            httpRequest.sendBuffer(buffer).map(this::buildResponse).onSuccess(rfuture::complete).onFailure(rfuture::completeExceptionally);
        }
        catch (Exception e) {
            rfuture.completeExceptionally(e);
        }
    }

    private InternalResponse buildResponse(HttpResponse<Buffer> httpResponse) {
        byte[] bytes;
        InternalResponse response = new InternalResponse();
        response.setResponseCode(httpResponse.statusCode());
        Buffer body = httpResponse.body();
        if (body != null && (bytes = body.getBytes()).length > 0) {
            response.setBody(bytes);
        }
        for (Map.Entry header : httpResponse.headers()) {
            response.putMeta((String)header.getKey(), (String)header.getValue());
        }
        return response;
    }

    @Override
    public void setJwt(String jwt) {
        if (jwt != null) {
            this.auth = new TokenCredentials(jwt).toHttpAuthorization();
        }
    }
}

