/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.http.compression;

import com.arangodb.shaded.netty.buffer.ByteBuf;
import com.arangodb.shaded.netty.buffer.ByteBufAllocator;
import com.arangodb.shaded.netty.handler.codec.compression.ZlibWrapper;
import com.arangodb.shaded.netty.util.internal.ObjectUtil;
import com.arangodb.shaded.netty.util.internal.SystemPropertyUtil;
import com.arangodb.shaded.netty.util.internal.logging.InternalLogger;
import com.arangodb.shaded.netty.util.internal.logging.InternalLoggerFactory;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

class JdkZlibEncoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(JdkZlibEncoder.class);
    private static final int MAX_INITIAL_OUTPUT_BUFFER_SIZE;
    private static final int MAX_INPUT_BUFFER_SIZE;
    private final ZlibWrapper wrapper;
    private final Deflater deflater;
    private final CRC32 crc = new CRC32();
    private static final byte[] gzipHeader;

    private static ByteBuf allocateByteBuf(int len) {
        return ByteBufAllocator.DEFAULT.heapBuffer(len);
    }

    private static ByteBuf allocateByteBuf() {
        return ByteBufAllocator.DEFAULT.heapBuffer();
    }

    private static ByteBuf emptyBuf() {
        return ByteBufAllocator.DEFAULT.heapBuffer(0, 0);
    }

    JdkZlibEncoder(ZlibWrapper wrapper, int compressionLevel) {
        ObjectUtil.checkInRange(compressionLevel, 0, 9, "compressionLevel");
        ObjectUtil.checkNotNull(wrapper, "wrapper");
        if (wrapper == ZlibWrapper.ZLIB_OR_NONE) {
            throw new IllegalArgumentException("wrapper '" + (Object)((Object)ZlibWrapper.ZLIB_OR_NONE) + "' is not allowed for compression.");
        }
        this.wrapper = wrapper;
        this.deflater = new Deflater(compressionLevel, wrapper != ZlibWrapper.ZLIB);
    }

    ByteBuf encode(byte[] in) {
        if (in.length == 0) {
            return JdkZlibEncoder.emptyBuf();
        }
        ByteBuf out = this.allocateBuffer(in.length);
        this.encodeSome(in, out);
        this.finishEncode(out);
        return out;
    }

    private void encodeSome(byte[] in, ByteBuf out) {
        if (this.wrapper == ZlibWrapper.GZIP) {
            out.writeBytes(gzipHeader);
        }
        if (this.wrapper == ZlibWrapper.GZIP) {
            this.crc.update(in, 0, in.length);
        }
        this.deflater.setInput(in);
        while (true) {
            this.deflate(out);
            if (!out.isWritable()) {
                out.ensureWritable(out.writerIndex());
                continue;
            }
            if (this.deflater.needsInput()) break;
        }
    }

    private ByteBuf allocateBuffer(int length) {
        int sizeEstimate = (int)Math.ceil((double)length * 1.001) + 12;
        switch (this.wrapper) {
            case GZIP: {
                sizeEstimate += gzipHeader.length;
                break;
            }
            case ZLIB: {
                sizeEstimate += 2;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (sizeEstimate < 0 || sizeEstimate > MAX_INITIAL_OUTPUT_BUFFER_SIZE) {
            return JdkZlibEncoder.allocateByteBuf(MAX_INITIAL_OUTPUT_BUFFER_SIZE);
        }
        return JdkZlibEncoder.allocateByteBuf(sizeEstimate);
    }

    private void finishEncode(ByteBuf out) {
        ByteBuf footer = JdkZlibEncoder.allocateByteBuf();
        this.deflater.finish();
        while (!this.deflater.finished()) {
            this.deflate(footer);
        }
        if (this.wrapper == ZlibWrapper.GZIP) {
            int crcValue = (int)this.crc.getValue();
            int uncBytes = this.deflater.getTotalIn();
            footer.writeByte(crcValue);
            footer.writeByte(crcValue >>> 8);
            footer.writeByte(crcValue >>> 16);
            footer.writeByte(crcValue >>> 24);
            footer.writeByte(uncBytes);
            footer.writeByte(uncBytes >>> 8);
            footer.writeByte(uncBytes >>> 16);
            footer.writeByte(uncBytes >>> 24);
        }
        out.writeBytes(footer);
        this.deflater.reset();
        this.crc.reset();
    }

    private void deflate(ByteBuf out) {
        int numBytes;
        do {
            int writerIndex = out.writerIndex();
            numBytes = this.deflater.deflate(out.array(), out.arrayOffset() + writerIndex, out.writableBytes(), 2);
            out.writerIndex(writerIndex + numBytes);
        } while (numBytes > 0);
    }

    void close() {
        this.deflater.reset();
        this.deflater.end();
    }

    static {
        gzipHeader = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
        MAX_INITIAL_OUTPUT_BUFFER_SIZE = SystemPropertyUtil.getInt("com.arangodb.shaded.netty.jdkzlib.encoder.maxInitialOutputBufferSize", 65536);
        MAX_INPUT_BUFFER_SIZE = SystemPropertyUtil.getInt("com.arangodb.shaded.netty.jdkzlib.encoder.maxInputBufferSize", 65536);
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.jdkzlib.encoder.maxInitialOutputBufferSize={}", (Object)MAX_INITIAL_OUTPUT_BUFFER_SIZE);
            logger.debug("-Dio.netty.jdkzlib.encoder.maxInputBufferSize={}", (Object)MAX_INPUT_BUFFER_SIZE);
        }
    }
}

