/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.ArangoSearch;
import com.arangodb.entity.ViewEntity;
import com.arangodb.entity.arangosearch.ArangoSearchPropertiesEntity;
import com.arangodb.internal.ArangoDatabaseImpl;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.InternalArangoSearch;
import com.arangodb.model.arangosearch.ArangoSearchCreateOptions;
import com.arangodb.model.arangosearch.ArangoSearchPropertiesOptions;
import java.lang.reflect.Type;

public class ArangoSearchImpl
extends InternalArangoSearch
implements ArangoSearch {
    private final ArangoDatabase db;

    protected ArangoSearchImpl(ArangoDatabaseImpl db, String name) {
        super(db, db.name(), name);
        this.db = db;
    }

    @Override
    public ArangoDatabase db() {
        return this.db;
    }

    @Override
    public boolean exists() {
        try {
            this.getInfo();
            return true;
        }
        catch (ArangoDBException e) {
            if (ArangoErrors.matches(e, 404, ArangoErrors.ERROR_ARANGO_DATA_SOURCE_NOT_FOUND)) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public void drop() {
        this.executorSync().execute(this.dropRequest(), (Type)((Object)Void.class));
    }

    @Override
    public ViewEntity rename(String newName) {
        return (ViewEntity)this.executorSync().execute(this.renameRequest(newName), (Type)((Object)ViewEntity.class));
    }

    @Override
    public ViewEntity getInfo() {
        return (ViewEntity)this.executorSync().execute(this.getInfoRequest(), (Type)((Object)ViewEntity.class));
    }

    @Override
    public ViewEntity create() {
        return this.create(new ArangoSearchCreateOptions());
    }

    @Override
    public ViewEntity create(ArangoSearchCreateOptions options) {
        return this.db().createArangoSearch(this.name(), options);
    }

    @Override
    public ArangoSearchPropertiesEntity getProperties() {
        return (ArangoSearchPropertiesEntity)this.executorSync().execute(this.getPropertiesRequest(), (Type)((Object)ArangoSearchPropertiesEntity.class));
    }

    @Override
    public ArangoSearchPropertiesEntity updateProperties(ArangoSearchPropertiesOptions options) {
        return (ArangoSearchPropertiesEntity)this.executorSync().execute(this.updatePropertiesRequest(options), (Type)((Object)ArangoSearchPropertiesEntity.class));
    }

    @Override
    public ArangoSearchPropertiesEntity replaceProperties(ArangoSearchPropertiesOptions options) {
        return (ArangoSearchPropertiesEntity)this.executorSync().execute(this.replacePropertiesRequest(options), (Type)((Object)ArangoSearchPropertiesEntity.class));
    }
}

