/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.jackson.dataformat.velocypack.internal;

import com.arangodb.shaded.fasterxml.jackson.core.Base64Variant;
import com.arangodb.shaded.fasterxml.jackson.core.ObjectCodec;
import com.arangodb.shaded.fasterxml.jackson.core.SerializableString;
import com.arangodb.shaded.fasterxml.jackson.core.Version;
import com.arangodb.shaded.fasterxml.jackson.core.base.GeneratorBase;
import com.arangodb.shaded.fasterxml.jackson.core.io.IOContext;
import com.arangodb.shaded.fasterxml.jackson.core.json.PackageVersion;
import com.arangodb.velocypack.VPackBuilder;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.ValueType;
import com.arangodb.velocypack.exception.VPackBuilderException;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public class VPackGenerator
extends GeneratorBase {
    protected final VPackBuilder builder;
    protected String attribute;
    protected final IOContext ioContext;
    protected final OutputStream out;

    public VPackGenerator(IOContext ioCtxt, int streamWriteFeatures, ObjectCodec codec, OutputStream out) {
        super(streamWriteFeatures, codec);
        this.ioContext = ioCtxt;
        this.out = out;
        this.builder = new VPackBuilder();
        this.attribute = null;
    }

    @Override
    public void writeStartObject() throws IOException {
        try {
            this.builder.add(this.attribute, ValueType.OBJECT);
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeEndObject() throws IOException {
        try {
            this.builder.close();
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeFieldName(String s) throws IOException {
        this.attribute = s;
    }

    @Override
    public void writeFieldName(SerializableString serializableString) throws IOException {
        this.attribute = serializableString.getValue();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void writeString(String s) throws IOException {
        try {
            this.builder.add(this.attribute, s);
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeString(char[] chars, int i, int i1) throws IOException {
        try {
            this.builder.add(this.attribute, new String(chars, i, i1));
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeRawUTF8String(byte[] bytes, int i, int i1) throws IOException {
        try {
            this.builder.add(this.attribute, new String(bytes, i, i1));
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeUTF8String(byte[] bytes, int i, int i1) throws IOException {
        try {
            this.builder.add(this.attribute, new String(bytes, i, i1));
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeRaw(String s) throws IOException {
        throw new UnsupportedOperationException("writeRaw is not supported");
    }

    @Override
    public void writeRaw(String s, int i, int i1) throws IOException {
        throw new UnsupportedOperationException("writeRaw is not supported");
    }

    @Override
    public void writeRaw(char[] chars, int i, int i1) throws IOException {
        throw new UnsupportedOperationException("writeRaw is not supported");
    }

    @Override
    public void writeRaw(char c) throws IOException {
        throw new UnsupportedOperationException("writeRaw is not supported");
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] bytes, int i, int i1) throws IOException {
        try {
            this.builder.add(this.attribute, base64Variant.encode(bytes, false));
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    public void writeVPack(VPackSlice vpack) throws IOException {
        try {
            this.builder.add(this.attribute, vpack);
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeNumber(int i) throws IOException {
        try {
            this.builder.add(this.attribute, i);
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeNumber(long l) throws IOException {
        try {
            this.builder.add(this.attribute, l);
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeNumber(BigInteger bigInteger) throws IOException {
        try {
            this.builder.add(this.attribute, bigInteger);
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeNumber(double v) throws IOException {
        try {
            this.builder.add(this.attribute, v);
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeNumber(float v) throws IOException {
        try {
            this.builder.add(this.attribute, Float.valueOf(v));
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) throws IOException {
        try {
            this.builder.add(this.attribute, bigDecimal);
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeNumber(String s) throws IOException {
        BigInteger bi = new BigInteger(s);
        if (bi.toString().equals(s)) {
            this.writeNumber(bi);
        } else {
            this.writeNumber(new BigDecimal(s));
        }
    }

    @Override
    public void writeBoolean(boolean b) throws IOException {
        try {
            this.builder.add(this.attribute, (Boolean)b);
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeNull() throws IOException {
        try {
            this.builder.add(this.attribute, ValueType.NULL);
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeStartArray() throws IOException {
        try {
            this.builder.add(this.attribute, ValueType.ARRAY);
            this.attribute = null;
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeEndArray() throws IOException {
        try {
            this.builder.close();
        }
        catch (VPackBuilderException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.out.write(this.builder.slice().toByteArray());
        super.close();
    }

    @Override
    protected void _releaseBuffers() {
    }

    @Override
    protected void _verifyValueWrite(String s) throws IOException {
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }
}

