/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.netty.handler.codec.dns;

import com.arangodb.shaded.netty.buffer.ByteBuf;
import com.arangodb.shaded.netty.channel.ChannelHandlerContext;
import com.arangodb.shaded.netty.handler.codec.LengthFieldBasedFrameDecoder;
import com.arangodb.shaded.netty.handler.codec.dns.DefaultDnsQuery;
import com.arangodb.shaded.netty.handler.codec.dns.DnsMessageUtil;
import com.arangodb.shaded.netty.handler.codec.dns.DnsOpCode;
import com.arangodb.shaded.netty.handler.codec.dns.DnsQuery;
import com.arangodb.shaded.netty.handler.codec.dns.DnsRecordDecoder;
import com.arangodb.shaded.netty.util.internal.ObjectUtil;

public final class TcpDnsQueryDecoder
extends LengthFieldBasedFrameDecoder {
    private final DnsRecordDecoder decoder;

    public TcpDnsQueryDecoder() {
        this(DnsRecordDecoder.DEFAULT, 65535);
    }

    public TcpDnsQueryDecoder(DnsRecordDecoder decoder, int maxFrameLength) {
        super(maxFrameLength, 0, 2, 0, 2);
        this.decoder = ObjectUtil.checkNotNull(decoder, "decoder");
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        ByteBuf frame = (ByteBuf)super.decode(ctx, in);
        if (frame == null) {
            return null;
        }
        return DnsMessageUtil.decodeDnsQuery(this.decoder, frame.slice(), new DnsMessageUtil.DnsQueryFactory(){

            @Override
            public DnsQuery newQuery(int id, DnsOpCode dnsOpCode) {
                return new DefaultDnsQuery(id, dnsOpCode);
            }
        });
    }
}

