/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.netty.handler.codec.rtsp;

import com.arangodb.shaded.netty.buffer.Unpooled;
import com.arangodb.shaded.netty.handler.codec.http.DefaultFullHttpRequest;
import com.arangodb.shaded.netty.handler.codec.http.DefaultFullHttpResponse;
import com.arangodb.shaded.netty.handler.codec.http.DefaultHttpRequest;
import com.arangodb.shaded.netty.handler.codec.http.DefaultHttpResponse;
import com.arangodb.shaded.netty.handler.codec.http.HttpDecoderConfig;
import com.arangodb.shaded.netty.handler.codec.http.HttpMessage;
import com.arangodb.shaded.netty.handler.codec.http.HttpObjectDecoder;
import com.arangodb.shaded.netty.handler.codec.http.HttpResponseStatus;
import com.arangodb.shaded.netty.handler.codec.rtsp.RtspHeaderNames;
import com.arangodb.shaded.netty.handler.codec.rtsp.RtspMethods;
import com.arangodb.shaded.netty.handler.codec.rtsp.RtspVersions;
import java.util.regex.Pattern;

public class RtspDecoder
extends HttpObjectDecoder {
    private static final HttpResponseStatus UNKNOWN_STATUS = new HttpResponseStatus(999, "Unknown");
    private boolean isDecodingRequest;
    private static final Pattern versionPattern = Pattern.compile("RTSP/\\d\\.\\d");
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 8192;

    public RtspDecoder() {
        this(4096, 8192, 8192);
    }

    public RtspDecoder(int maxInitialLineLength, int maxHeaderSize, int maxContentLength) {
        super(new HttpDecoderConfig().setMaxInitialLineLength(maxInitialLineLength).setMaxHeaderSize(maxHeaderSize).setMaxChunkSize(maxContentLength * 2).setChunkedSupported(false));
    }

    @Deprecated
    public RtspDecoder(int maxInitialLineLength, int maxHeaderSize, int maxContentLength, boolean validateHeaders) {
        super(new HttpDecoderConfig().setMaxInitialLineLength(maxInitialLineLength).setMaxHeaderSize(maxHeaderSize).setMaxChunkSize(maxContentLength * 2).setChunkedSupported(false).setValidateHeaders(validateHeaders));
    }

    public RtspDecoder(HttpDecoderConfig config) {
        super(config.clone().setMaxChunkSize(2 * config.getMaxChunkSize()).setChunkedSupported(false));
    }

    @Override
    protected HttpMessage createMessage(String[] initialLine) throws Exception {
        if (versionPattern.matcher(initialLine[0]).matches()) {
            this.isDecodingRequest = false;
            return new DefaultHttpResponse(RtspVersions.valueOf(initialLine[0]), new HttpResponseStatus(Integer.parseInt(initialLine[1]), initialLine[2]), this.headersFactory);
        }
        this.isDecodingRequest = true;
        return new DefaultHttpRequest(RtspVersions.valueOf(initialLine[2]), RtspMethods.valueOf(initialLine[0]), initialLine[1], this.headersFactory);
    }

    @Override
    protected boolean isContentAlwaysEmpty(HttpMessage msg) {
        return super.isContentAlwaysEmpty(msg) || !msg.headers().contains(RtspHeaderNames.CONTENT_LENGTH);
    }

    @Override
    protected HttpMessage createInvalidMessage() {
        if (this.isDecodingRequest) {
            return new DefaultFullHttpRequest(RtspVersions.RTSP_1_0, RtspMethods.OPTIONS, "/bad-request", Unpooled.buffer(0), this.headersFactory, this.trailersFactory);
        }
        return new DefaultFullHttpResponse(RtspVersions.RTSP_1_0, UNKNOWN_STATUS, Unpooled.buffer(0), this.headersFactory, this.trailersFactory);
    }

    @Override
    protected boolean isDecodingRequest() {
        return this.isDecodingRequest;
    }
}

