/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core;

import com.arangodb.shaded.vertx.core.DeploymentOptions;
import com.arangodb.shaded.vertx.core.ThreadingModel;
import com.arangodb.shaded.vertx.core.json.JsonObject;
import com.arangodb.shaded.vertx.core.json.impl.JsonUtil;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DeploymentOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, DeploymentOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "config": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setConfig(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "ha": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setHa((Boolean)member.getValue());
                    break;
                }
                case "instances": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setInstances(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxWorkerExecuteTime": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxWorkerExecuteTime(((Number)member.getValue()).longValue());
                    break;
                }
                case "maxWorkerExecuteTimeUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMaxWorkerExecuteTimeUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "threadingModel": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setThreadingModel(ThreadingModel.valueOf((String)member.getValue()));
                    break;
                }
                case "worker": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setWorker((Boolean)member.getValue());
                    break;
                }
                case "workerPoolName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setWorkerPoolName((String)member.getValue());
                    break;
                }
                case "workerPoolSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setWorkerPoolSize(((Number)member.getValue()).intValue());
                }
            }
        }
    }

    static void toJson(DeploymentOptions obj, JsonObject json) {
        DeploymentOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(DeploymentOptions obj, Map<String, Object> json) {
        if (obj.getConfig() != null) {
            json.put("config", obj.getConfig());
        }
        json.put("ha", obj.isHa());
        json.put("instances", obj.getInstances());
        json.put("maxWorkerExecuteTime", obj.getMaxWorkerExecuteTime());
        if (obj.getMaxWorkerExecuteTimeUnit() != null) {
            json.put("maxWorkerExecuteTimeUnit", obj.getMaxWorkerExecuteTimeUnit().name());
        }
        if (obj.getThreadingModel() != null) {
            json.put("threadingModel", obj.getThreadingModel().name());
        }
        json.put("worker", obj.isWorker());
        if (obj.getWorkerPoolName() != null) {
            json.put("workerPoolName", obj.getWorkerPoolName());
        }
        json.put("workerPoolSize", obj.getWorkerPoolSize());
    }
}

