/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core;

import com.arangodb.shaded.vertx.codegen.annotations.Fluent;
import com.arangodb.shaded.vertx.codegen.annotations.GenIgnore;
import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.CompositeFuture;
import com.arangodb.shaded.vertx.core.Context;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.Promise;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import com.arangodb.shaded.vertx.core.impl.Utils;
import com.arangodb.shaded.vertx.core.impl.WorkerExecutor;
import com.arangodb.shaded.vertx.core.impl.future.CompositeFutureImpl;
import com.arangodb.shaded.vertx.core.impl.future.FailedFuture;
import com.arangodb.shaded.vertx.core.impl.future.PromiseInternal;
import com.arangodb.shaded.vertx.core.impl.future.SucceededFuture;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Future<T>
extends AsyncResult<T> {
    public static CompositeFuture all(Future<?> f1, Future<?> f2) {
        return CompositeFutureImpl.all(new Future[]{f1, f2});
    }

    public static CompositeFuture all(Future<?> f1, Future<?> f2, Future<?> f3) {
        return CompositeFutureImpl.all(new Future[]{f1, f2, f3});
    }

    public static CompositeFuture all(Future<?> f1, Future<?> f2, Future<?> f3, Future<?> f4) {
        return CompositeFutureImpl.all(new Future[]{f1, f2, f3, f4});
    }

    public static CompositeFuture all(Future<?> f1, Future<?> f2, Future<?> f3, Future<?> f4, Future<?> f5) {
        return CompositeFutureImpl.all(new Future[]{f1, f2, f3, f4, f5});
    }

    public static CompositeFuture all(Future<?> f1, Future<?> f2, Future<?> f3, Future<?> f4, Future<?> f5, Future<?> f6) {
        return CompositeFutureImpl.all(new Future[]{f1, f2, f3, f4, f5, f6});
    }

    public static CompositeFuture all(List<? extends Future<?>> futures) {
        return CompositeFutureImpl.all(futures.toArray(new Future[0]));
    }

    public static CompositeFuture any(Future<?> f1, Future<?> f2) {
        return CompositeFutureImpl.any(new Future[]{f1, f2});
    }

    public static CompositeFuture any(Future<?> f1, Future<?> f2, Future<?> f3) {
        return CompositeFutureImpl.any(new Future[]{f1, f2, f3});
    }

    public static CompositeFuture any(Future<?> f1, Future<?> f2, Future<?> f3, Future<?> f4) {
        return CompositeFutureImpl.any(new Future[]{f1, f2, f3, f4});
    }

    public static CompositeFuture any(Future<?> f1, Future<?> f2, Future<?> f3, Future<?> f4, Future<?> f5) {
        return CompositeFutureImpl.any(new Future[]{f1, f2, f3, f4, f5});
    }

    public static CompositeFuture any(Future<?> f1, Future<?> f2, Future<?> f3, Future<?> f4, Future<?> f5, Future<?> f6) {
        return CompositeFutureImpl.any(new Future[]{f1, f2, f3, f4, f5, f6});
    }

    public static CompositeFuture any(List<? extends Future<?>> futures) {
        return CompositeFutureImpl.any(futures.toArray(new Future[0]));
    }

    public static CompositeFuture join(Future<?> f1, Future<?> f2) {
        return CompositeFutureImpl.join(new Future[]{f1, f2});
    }

    public static CompositeFuture join(Future<?> f1, Future<?> f2, Future<?> f3) {
        return CompositeFutureImpl.join(new Future[]{f1, f2, f3});
    }

    public static CompositeFuture join(Future<?> f1, Future<?> f2, Future<?> f3, Future<?> f4) {
        return CompositeFutureImpl.join(new Future[]{f1, f2, f3, f4});
    }

    public static CompositeFuture join(Future<?> f1, Future<?> f2, Future<?> f3, Future<?> f4, Future<?> f5) {
        return CompositeFutureImpl.join(new Future[]{f1, f2, f3, f4, f5});
    }

    public static CompositeFuture join(Future<?> f1, Future<?> f2, Future<?> f3, Future<?> f4, Future<?> f5, Future<?> f6) {
        return CompositeFutureImpl.join(new Future[]{f1, f2, f3, f4, f5, f6});
    }

    public static CompositeFuture join(List<? extends Future<?>> futures) {
        return CompositeFutureImpl.join(futures.toArray(new Future[0]));
    }

    public static <T> Future<T> future(Handler<Promise<T>> handler) {
        Promise promise = Promise.promise();
        try {
            handler.handle(promise);
        }
        catch (Throwable e) {
            promise.tryFail(e);
        }
        return promise.future();
    }

    public static <T> Future<T> succeededFuture() {
        return SucceededFuture.EMPTY;
    }

    public static <T> Future<T> succeededFuture(T result) {
        if (result == null) {
            return Future.succeededFuture();
        }
        return new SucceededFuture<T>(result);
    }

    public static <T> Future<T> failedFuture(Throwable t) {
        return new FailedFuture(t);
    }

    public static <T> Future<T> failedFuture(String failureMessage) {
        return new FailedFuture(failureMessage);
    }

    public boolean isComplete();

    @Fluent
    public Future<T> onComplete(Handler<AsyncResult<T>> var1);

    default public Future<T> onComplete(Handler<T> successHandler, Handler<Throwable> failureHandler) {
        return this.onComplete(ar -> {
            if (successHandler != null && ar.succeeded()) {
                successHandler.handle(ar.result());
            } else if (failureHandler != null && ar.failed()) {
                failureHandler.handle(ar.cause());
            }
        });
    }

    @Fluent
    default public Future<T> onSuccess(Handler<T> handler) {
        return this.onComplete(handler, null);
    }

    @Fluent
    default public Future<T> onFailure(Handler<Throwable> handler) {
        return this.onComplete(null, handler);
    }

    @Override
    public T result();

    @Override
    public Throwable cause();

    @Override
    public boolean succeeded();

    @Override
    public boolean failed();

    default public <U> Future<U> flatMap(Function<T, Future<U>> mapper) {
        return this.compose(mapper);
    }

    default public <U> Future<U> compose(Function<T, Future<U>> mapper) {
        return this.compose(mapper, Future::failedFuture);
    }

    default public Future<T> recover(Function<Throwable, Future<T>> mapper) {
        return this.compose(Future::succeededFuture, mapper);
    }

    public <U> Future<U> compose(Function<T, Future<U>> var1, Function<Throwable, Future<U>> var2);

    public <U> Future<U> transform(Function<AsyncResult<T>, Future<U>> var1);

    @Deprecated
    public <U> Future<T> eventually(Function<Void, Future<U>> var1);

    default public <U> Future<T> eventually(Supplier<Future<U>> supplier) {
        return this.eventually((Void v) -> (Future)supplier.get());
    }

    @Override
    public <U> Future<U> map(Function<T, U> var1);

    @Override
    public <V> Future<V> map(V var1);

    @Override
    default public <V> Future<V> mapEmpty() {
        return (Future)AsyncResult.super.mapEmpty();
    }

    @Override
    public Future<T> otherwise(Function<Throwable, T> var1);

    @Override
    public Future<T> otherwise(T var1);

    @Override
    default public Future<T> otherwiseEmpty() {
        return (Future)AsyncResult.super.otherwiseEmpty();
    }

    default public Future<T> andThen(Handler<AsyncResult<T>> handler) {
        return this.transform(ar -> {
            handler.handle((AsyncResult)ar);
            return (Future)ar;
        });
    }

    public Future<T> timeout(long var1, TimeUnit var3);

    @GenIgnore
    default public CompletionStage<T> toCompletionStage() {
        CompletableFuture completableFuture = new CompletableFuture();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                completableFuture.complete(ar.result());
            } else {
                completableFuture.completeExceptionally(ar.cause());
            }
        });
        return completableFuture;
    }

    @GenIgnore
    public static <T> Future<T> fromCompletionStage(CompletionStage<T> completionStage) {
        Promise promise = Promise.promise();
        completionStage.whenComplete((value, err) -> {
            if (err != null) {
                promise.fail((Throwable)err);
            } else {
                promise.complete(value);
            }
        });
        return promise.future();
    }

    @GenIgnore
    public static <T> Future<T> fromCompletionStage(CompletionStage<T> completionStage, Context context) {
        PromiseInternal promise = ((ContextInternal)context).promise();
        completionStage.whenComplete((value, err) -> {
            if (err != null) {
                promise.fail((Throwable)err);
            } else {
                promise.complete(value);
            }
        });
        return promise.future();
    }

    public static <T> T await(Future<T> future) {
        WorkerExecutor executor = WorkerExecutor.unwrapWorkerExecutor();
        WorkerExecutor.TaskController cont = executor.current();
        future.onComplete(ar -> cont.resume());
        try {
            cont.suspendAndAwaitResume();
        }
        catch (InterruptedException e) {
            Utils.throwAsUnchecked(e);
            return null;
        }
        if (future.succeeded()) {
            return future.result();
        }
        Utils.throwAsUnchecked(future.cause());
        return null;
    }
}

