/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.eventbus.impl;

import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.Promise;
import com.arangodb.shaded.vertx.core.Vertx;
import com.arangodb.shaded.vertx.core.eventbus.DeliveryOptions;
import com.arangodb.shaded.vertx.core.eventbus.MessageProducer;
import com.arangodb.shaded.vertx.core.eventbus.impl.EventBusImpl;
import com.arangodb.shaded.vertx.core.eventbus.impl.MessageImpl;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import com.arangodb.shaded.vertx.core.impl.VertxInternal;
import com.arangodb.shaded.vertx.core.impl.future.PromiseInternal;

public class MessageProducerImpl<T>
implements MessageProducer<T> {
    private final Vertx vertx;
    private final EventBusImpl bus;
    private final boolean send;
    private final String address;
    private final boolean localOnly;
    private DeliveryOptions options;

    public MessageProducerImpl(Vertx vertx, String address, boolean send, DeliveryOptions options) {
        this.vertx = vertx;
        this.bus = (EventBusImpl)vertx.eventBus();
        this.address = address;
        this.send = send;
        this.options = options;
        this.localOnly = vertx.isClustered() ? options.isLocalOnly() : true;
    }

    @Override
    public synchronized MessageProducer<T> deliveryOptions(DeliveryOptions options) {
        this.options = options;
        return this;
    }

    @Override
    public Future<Void> write(T body) {
        PromiseInternal<Void> promise = ((VertxInternal)this.vertx).getOrCreateContext().promise();
        this.write(body, (Promise<Void>)promise);
        return promise.future();
    }

    @Override
    public void write(T body, Handler<AsyncResult<Void>> handler) {
        PromiseInternal promise = null;
        if (handler != null) {
            promise = ((VertxInternal)this.vertx).getOrCreateContext().promise(handler);
        }
        this.write(body, promise);
    }

    private void write(T data, Promise<Void> handler) {
        MessageImpl msg = this.bus.createMessage(this.send, this.localOnly, this.address, this.options.getHeaders(), data, this.options.getCodecName());
        this.bus.sendOrPubInternal(msg, this.options, null, handler);
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public Future<Void> close() {
        return ((ContextInternal)this.vertx.getOrCreateContext()).succeededFuture();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.close();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }
}

