/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.eventbus.impl.codecs;

import com.arangodb.shaded.netty.util.CharsetUtil;
import com.arangodb.shaded.vertx.core.buffer.Buffer;
import com.arangodb.shaded.vertx.core.eventbus.MessageCodec;

public class StringMessageCodec
implements MessageCodec<String, String> {
    @Override
    public void encodeToWire(Buffer buffer, String s) {
        byte[] strBytes = s.getBytes(CharsetUtil.UTF_8);
        buffer.appendInt(strBytes.length);
        buffer.appendBytes(strBytes);
    }

    @Override
    public String decodeFromWire(int pos, Buffer buffer) {
        int length = buffer.getInt(pos);
        byte[] bytes = buffer.getBytes(pos += 4, pos + length);
        return new String(bytes, CharsetUtil.UTF_8);
    }

    @Override
    public String transform(String s) {
        return s;
    }

    @Override
    public String name() {
        return "string";
    }

    @Override
    public byte systemCodecID() {
        return 9;
    }
}

