/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.http;

import com.arangodb.shaded.vertx.codegen.annotations.CacheReturn;
import com.arangodb.shaded.vertx.codegen.annotations.Fluent;
import com.arangodb.shaded.vertx.codegen.annotations.GenIgnore;
import com.arangodb.shaded.vertx.codegen.annotations.Nullable;
import com.arangodb.shaded.vertx.codegen.annotations.VertxGen;
import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.MultiMap;
import com.arangodb.shaded.vertx.core.buffer.Buffer;
import com.arangodb.shaded.vertx.core.http.HttpClientRequest;
import com.arangodb.shaded.vertx.core.http.HttpFrame;
import com.arangodb.shaded.vertx.core.http.HttpVersion;
import com.arangodb.shaded.vertx.core.http.StreamPriority;
import com.arangodb.shaded.vertx.core.net.NetSocket;
import com.arangodb.shaded.vertx.core.streams.ReadStream;
import java.util.List;

@VertxGen
public interface HttpClientResponse
extends ReadStream<Buffer> {
    public HttpClientResponse fetch(long var1);

    public HttpClientResponse resume();

    @Override
    public HttpClientResponse exceptionHandler(Handler<Throwable> var1);

    public HttpClientResponse handler(Handler<Buffer> var1);

    public HttpClientResponse pause();

    public HttpClientResponse endHandler(Handler<Void> var1);

    @CacheReturn
    public NetSocket netSocket();

    public HttpVersion version();

    public int statusCode();

    public String statusMessage();

    @CacheReturn
    public MultiMap headers();

    public @Nullable String getHeader(String var1);

    @GenIgnore(value={"permitted-type"})
    public String getHeader(CharSequence var1);

    public @Nullable String getTrailer(String var1);

    @CacheReturn
    public MultiMap trailers();

    @CacheReturn
    public List<String> cookies();

    @Fluent
    default public HttpClientResponse bodyHandler(Handler<Buffer> bodyHandler) {
        this.body().onSuccess(bodyHandler);
        return this;
    }

    @Fluent
    default public HttpClientResponse body(Handler<AsyncResult<Buffer>> handler) {
        Future<Buffer> fut = this.body();
        fut.onComplete(handler);
        return this;
    }

    public Future<Buffer> body();

    default public void end(Handler<AsyncResult<Void>> handler) {
        this.end().onComplete(handler);
    }

    public Future<Void> end();

    @Fluent
    public HttpClientResponse customFrameHandler(Handler<HttpFrame> var1);

    @CacheReturn
    public HttpClientRequest request();

    @Fluent
    public HttpClientResponse streamPriorityHandler(Handler<StreamPriority> var1);
}

