/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.http;

import com.arangodb.shaded.vertx.core.VertxException;
import com.arangodb.shaded.vertx.core.http.GoAway;

public class HttpClosedException
extends VertxException {
    private final GoAway goAway;

    private static String formatErrorMessage(GoAway goAway) {
        if (goAway == null) {
            return "Connection was closed";
        }
        return "Stream was closed (GOAWAY error code = " + goAway.getErrorCode() + ")";
    }

    public HttpClosedException(String message) {
        super(message, true);
        this.goAway = null;
    }

    public HttpClosedException(GoAway goAway) {
        super(HttpClosedException.formatErrorMessage(goAway), true);
        this.goAway = goAway;
    }

    public GoAway goAway() {
        return this.goAway != null ? new GoAway(this.goAway) : null;
    }
}

